/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.jdbc2xml.schema;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.TimeZone;
import org.clazzes.jdbc2xml.helper.ServiceHelper;
import org.clazzes.jdbc2xml.schema.Dialect;
import org.clazzes.jdbc2xml.schema.DialectFactory;
import org.clazzes.jdbc2xml.schema.IDialectFactory;
import org.clazzes.jdbc2xml.schema.ISchemaEngine;
import org.clazzes.jdbc2xml.schema.impl.SchemaEngineImpl;

public abstract class SchemaEngine
implements ISchemaEngine {
    private final IDialectFactory dialectFactory;
    private Connection connection;
    private TimeZone timeZone = TimeZone.getDefault();
    private String schema;
    private Dialect dialect;

    public static ISchemaEngine newInstance() {
        return ServiceHelper.loadService(SchemaEngine.class, SchemaEngineImpl::new);
    }

    protected SchemaEngine() {
        this.dialectFactory = DialectFactory.newInstance();
    }

    protected SchemaEngine(IDialectFactory dialectFactory) {
        this.dialectFactory = dialectFactory;
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public void setConnection(Connection connection) throws SQLException {
        this.connection = connection;
        if (this.dialect == null) {
            this.dialect = this.dialectFactory.newDialect(connection.getMetaData());
        }
    }

    @Override
    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    @Override
    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    @Override
    public Dialect getDialect() {
        return this.dialect;
    }

    @Override
    public void setDialect(Dialect dialect) {
        this.dialect = dialect;
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    @Override
    public void setSchema(String schema) {
        this.schema = schema;
    }
}

