/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.jdbc2xml.sax.impl;

import java.sql.SQLException;
import org.clazzes.jdbc2xml.Constants;
import org.clazzes.jdbc2xml.helper.JAVAHelper;
import org.clazzes.jdbc2xml.sax.impl.InsertContext;
import org.clazzes.jdbc2xml.sax.impl.TableTagHandler;
import org.clazzes.jdbc2xml.schema.ForeignKeyInfo;
import org.clazzes.jdbc2xml.schema.IndexInfo;
import org.clazzes.jdbc2xml.schema.TableInfo;
import org.clazzes.util.xml.SAXTagHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class XmlDumpTagHandler
implements SAXTagHandler {
    private static final Logger log = LoggerFactory.getLogger(XmlDumpTagHandler.class);
    private InsertContext context;

    public XmlDumpTagHandler(InsertContext context) {
        this.context = context;
    }

    public void closeTag(String uri, String localName, String name) throws SAXException {
        if (this.context.getProcessRestrictionFilter().isProcessConstraints() && this.context.getParsedTables() != null) {
            for (TableInfo tableInfo : this.context.getParsedTables()) {
                if (tableInfo.getForeignKeys() == null || this.context.getParsedTables().size() <= 0) continue;
                try {
                    log.info("Adding " + tableInfo.getForeignKeys().size() + " foreign keys to table [" + tableInfo.getName() + "].");
                    if (this.context.getProcessRestrictionFilter().isCreateFKIndices()) {
                        for (ForeignKeyInfo fki : tableInfo.getForeignKeys()) {
                            Object iname;
                            if (fki.getName() == null) {
                                StringBuffer sb = new StringBuffer(tableInfo.getName());
                                for (String c : fki.getColumns()) {
                                    sb.append('_');
                                    sb.append(c);
                                }
                                sb.append("__FKIDX");
                                iname = sb.toString();
                            } else {
                                iname = fki.getName() + "__IDX";
                            }
                            IndexInfo indexInfo = new IndexInfo((String)iname, JAVAHelper.joinStrings(fki.getColumns()), null, false, null);
                            log.info("Adding extra foreign key index [" + (String)iname + "].");
                            this.context.getSchemaEngine().addIndex(tableInfo, indexInfo);
                        }
                    }
                    this.context.getSchemaEngine().createForeignKeys(tableInfo);
                    log.info("Finished adding " + tableInfo.getForeignKeys().size() + " foreign keys to table [" + tableInfo.getName() + "].");
                }
                catch (SQLException e) {
                    throw new SAXException("SQL error adding foregin keys to table [" + tableInfo.getName() + "].", e);
                }
            }
        }
        this.context.setParsedTables(null);
    }

    public void processCharacters(char[] ch, int start, int length) throws SAXException {
    }

    public SAXTagHandler startChildElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        if (!Constants.JDBC2XML_NS_URI.equals(uri)) {
            throw new SAXException("Namspace URI [" + uri + "] is not supported.");
        }
        if (Constants.TABLE_TAG_NAME.equals(localName)) {
            String tableName = atts.getValue(Constants.TABLE_TAG_NAME_ATT);
            boolean processCurrentTable = this.context.getProcessRestrictionFilter().processTable(tableName);
            if (processCurrentTable) {
                return new TableTagHandler(this.context, atts);
            }
            log.info("Skipping table [" + tableName + "].");
            return null;
        }
        if (Constants.QUERY_TAG_NAME.equals(localName)) {
            log.warn("Ignoring data of dumped query [" + atts.getValue(Constants.QUERY_TAG_SQL_ATT) + "].");
            return null;
        }
        throw new SAXException("xmldump child element [" + localName + "] is not supported.");
    }
}

