/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.jdbc2xml.sax.impl;

import java.sql.Connection;
import java.sql.SQLException;
import org.clazzes.jdbc2xml.Constants;
import org.clazzes.jdbc2xml.sax.impl.InsertContext;
import org.clazzes.jdbc2xml.sax.impl.RowTagHandler;
import org.clazzes.jdbc2xml.schema.TableInfo;
import org.clazzes.util.xml.SAXTagHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class RowSetTagHandler
implements SAXTagHandler {
    private InsertContext context;
    private TableInfo tableInfo;
    private RowTagHandler rowTagHandler;
    private boolean oldAutoCommit;

    public RowSetTagHandler(InsertContext context, TableInfo tableInfo) {
        this.context = context;
        this.tableInfo = tableInfo;
        this.rowTagHandler = null;
    }

    public void closeTag(String uri, String localName, String name) throws SAXException {
        if (this.rowTagHandler != null) {
            this.rowTagHandler.flush(true);
        }
        if (this.context.getProcessRestrictionFilter().isTransactional()) {
            try {
                Connection conn = this.context.getSchemaEngine().getConnection();
                conn.setAutoCommit(this.oldAutoCommit);
            }
            catch (SQLException e) {
                throw new SAXException("Unable to reset auto commit to [" + this.oldAutoCommit + "] for bulk inserts of table [" + this.tableInfo.getName() + "]", e);
            }
        }
    }

    public void processCharacters(char[] ch, int start, int length) throws SAXException {
    }

    public SAXTagHandler startChildElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        if (!Constants.JDBC2XML_NS_URI.equals(uri)) {
            throw new SAXException("Namspace URI [" + uri + "] is not supported.");
        }
        if (Constants.ROW_TAG_NAME.equals(localName)) {
            if (this.rowTagHandler == null) {
                this.rowTagHandler = new RowTagHandler(this.context, this.tableInfo);
                if (this.context.getProcessRestrictionFilter().isTransactional()) {
                    try {
                        Connection conn = this.context.getSchemaEngine().getConnection();
                        this.oldAutoCommit = conn.getAutoCommit();
                        conn.setAutoCommit(false);
                    }
                    catch (SQLException e) {
                        throw new SAXException("Unable to start transaction for bulk inserts of table [" + this.tableInfo.getName() + "]", e);
                    }
                }
            }
            return this.rowTagHandler;
        }
        throw new SAXException("rowset child element [" + localName + "] is not supported.");
    }
}

