/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.jdbc2xml.sax;

import org.clazzes.jdbc2xml.sax.XmlPrettyConfig;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class XmlPretty
implements ContentHandler {
    private final ContentHandler contentHandler;
    private char[] prettyChars;
    private int prettyDepth;
    private int singleLineCount;
    private String lastStartElement;
    private XmlPrettyConfig prettyConfig;
    private StringBuilder characterBuffer;

    public XmlPretty(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
        this.characterBuffer = new StringBuilder();
        this.prettyConfig = new XmlPrettyConfig(2, 8);
        this.initPrettyParams();
    }

    public XmlPretty(ContentHandler contentHandler, XmlPrettyConfig prettyConfig) {
        this.contentHandler = contentHandler;
        this.characterBuffer = new StringBuilder();
        this.prettyConfig = prettyConfig;
        this.initPrettyParams();
    }

    protected void initPrettyParams() {
        this.prettyDepth = 0;
        int maxPrettyLength = 1 + this.prettyConfig.getWidth() * this.prettyConfig.getMaxDepth();
        StringBuffer sb = new StringBuffer("\n");
        for (int i = 0; i < maxPrettyLength; ++i) {
            sb.append(' ');
        }
        this.prettyChars = sb.toString().toCharArray();
        this.singleLineCount = 0;
    }

    private void nextLine() throws SAXException {
        if (this.prettyConfig.isActive()) {
            this.contentHandler.ignorableWhitespace(this.prettyChars, 0, 1 + this.prettyConfig.getWidth() * Math.min(this.prettyDepth, this.prettyConfig.getMaxDepth()));
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.characterBuffer.append(ch, start, length);
    }

    @Override
    public void endDocument() throws SAXException {
        this.contentHandler.endDocument();
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.lastStartElement.equalsIgnoreCase(qName) && this.characterBuffer.length() > 0) {
            this.contentHandler.characters(this.characterBuffer.toString().toCharArray(), 0, this.characterBuffer.length());
        }
        this.characterBuffer.setLength(0);
        --this.prettyDepth;
        if (!qName.equals(this.lastStartElement) && this.singleLineCount == 0) {
            this.nextLine();
        }
        if (this.prettyConfig.getSingleLineTags().contains(qName)) {
            --this.singleLineCount;
        }
        this.contentHandler.endElement(uri, localName, qName);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        this.contentHandler.endPrefixMapping(prefix);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.contentHandler.ignorableWhitespace(ch, 0, 0);
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        this.contentHandler.processingInstruction(target, data);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.contentHandler.setDocumentLocator(locator);
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        this.contentHandler.skippedEntity(name);
    }

    @Override
    public void startDocument() throws SAXException {
        this.contentHandler.startDocument();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (this.singleLineCount == 0) {
            this.nextLine();
        }
        if (this.prettyConfig.getSingleLineTags().contains(qName)) {
            ++this.singleLineCount;
        }
        this.lastStartElement = qName;
        this.contentHandler.startElement(uri, localName, qName, atts);
        ++this.prettyDepth;
        this.characterBuffer.setLength(0);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.contentHandler.startPrefixMapping(prefix, uri);
    }

    public XmlPrettyConfig getPrettyConfig() {
        return this.prettyConfig;
    }
}

