/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.htpasswd.jaas;

import com.fasterxml.jackson.core.exc.StreamReadException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DatabindException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.Crypt;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.codec.digest.Md5Crypt;
import org.clazzes.login.htpasswd.jaas.HtpasswdFileHelper;
import org.clazzes.login.htpasswd.jaas.HtpasswdGroup;
import org.clazzes.login.htpasswd.jaas.IHtpasswdAuthService;
import org.mindrot.jbcrypt.BCrypt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtpasswdAuthService
implements IHtpasswdAuthService {
    private static final Logger log = LoggerFactory.getLogger(HtpasswdAuthService.class);
    private final Map<String, String> htUsers = new HashMap<String, String>();
    private final Map<String, List<HtpasswdGroup>> htGroups = new HashMap<String, List<HtpasswdGroup>>();
    private final Map<String, Map<String, String>> htClaims = new HashMap<String, Map<String, String>>();
    private Path htpasswdPath;
    private FileTime lastModified;
    private Path groupPath;
    private FileTime groupLastModified;
    private Path claimsPath;
    private FileTime claimsLastModified;

    @Override
    public boolean authenticate(String username, char[] password) {
        String storedPwd = this.htUsers.get(username);
        boolean authenticated = false;
        if (storedPwd != null) {
            String passwd = new String(password);
            if (storedPwd.startsWith("$2y$") || storedPwd.startsWith("$2a$")) {
                if (BCrypt.checkpw(passwd, storedPwd)) {
                    if (log.isDebugEnabled()) {
                        log.debug("BCrypt encoded password matched for user [{}]", (Object)username);
                    }
                    authenticated = true;
                }
            } else if (storedPwd.startsWith("$apr1$")) {
                if (storedPwd.equals(Md5Crypt.apr1Crypt((String)passwd, (String)storedPwd))) {
                    if (log.isDebugEnabled()) {
                        log.debug("Apache MD5 encoded password matched for user [{}]", (Object)username);
                    }
                    authenticated = true;
                }
            } else if (storedPwd.startsWith("{SHA}")) {
                String passwd64 = Base64.encodeBase64String((byte[])DigestUtils.sha1((String)passwd));
                if (storedPwd.substring("{SHA}".length()).equals(passwd64)) {
                    if (log.isDebugEnabled()) {
                        log.debug("Unsalted SHA-1 encoded password matched for user [{}]", (Object)username);
                    }
                    authenticated = true;
                }
            } else if (storedPwd.equals(Crypt.crypt((String)passwd, (String)storedPwd))) {
                if (log.isDebugEnabled()) {
                    log.debug("Libc crypt encoded password matched for user [{}]", (Object)username);
                }
                authenticated = true;
            } else if (log.isDebugEnabled()) {
                log.debug("Password for user [{}] did not match", (Object)username);
            }
        } else if (log.isDebugEnabled()) {
            log.debug("User [{}] not found in file [{}]", (Object)username, (Object)this.htpasswdPath);
        }
        return authenticated;
    }

    @Override
    public List<HtpasswdGroup> getUserGroups(String username) {
        List<HtpasswdGroup> groups = this.htGroups.get(username);
        if (groups == null) {
            return null;
        }
        return Collections.unmodifiableList(groups);
    }

    @Override
    public Map<String, String> getUserClaims(String username) {
        Map<String, String> claims = this.htClaims.get(username);
        if (claims == null) {
            return null;
        }
        return Collections.unmodifiableMap(claims);
    }

    public void readString(String fileContent) {
        this.htpasswdPath = null;
        this.htUsers.clear();
        this.lastModified = null;
        try (StringReader reader = new StringReader(fileContent);){
            this.htUsers.putAll(HtpasswdFileHelper.readHtpasswdFile(reader));
        }
        catch (IOException e) {
            log.error("Failed to read htpasswd file [{}]", (Object)fileContent, (Object)e);
        }
    }

    public void read(Path file) {
        this.htpasswdPath = file;
        this.htUsers.clear();
        if (Files.exists(this.htpasswdPath, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(file, StandardCharsets.UTF_8);){
                this.lastModified = Files.getLastModifiedTime(this.htpasswdPath, new LinkOption[0]);
                this.htUsers.putAll(HtpasswdFileHelper.readHtpasswdFile(reader));
                log.info("Successfully read [{}] user entries from htpasswd file [{}]", (Object)this.htUsers.size(), (Object)this.htpasswdPath);
            }
            catch (Exception e) {
                log.error("Failed to read htpasswd file [" + String.valueOf(this.htpasswdPath) + "]", (Throwable)e);
            }
        } else {
            log.warn("htpasswd file [{}] does not exist.", (Object)this.htpasswdPath);
            this.lastModified = null;
        }
    }

    private void addUserToGroup(HtpasswdGroup gn, String user) {
        List<HtpasswdGroup> groups = this.htGroups.get(user);
        if (groups == null) {
            groups = new ArrayList<HtpasswdGroup>();
            this.htGroups.put(user, groups);
        }
        groups.add(gn);
    }

    private void readGroupReader(Reader file) {
        Pattern entry = Pattern.compile("^([^:]+):([^:]+)");
        try (Scanner scanner = new Scanner(file);){
            while (scanner.hasNextLine()) {
                String[] users;
                Matcher m;
                String line = scanner.nextLine().trim();
                if (line.isEmpty() || line.startsWith("#") || !(m = entry.matcher(line)).matches()) continue;
                HtpasswdGroup gn = new HtpasswdGroup(m.group(1));
                for (String user : users = m.group(2).trim().split("\\s*,\\s*")) {
                    if (user.isEmpty()) continue;
                    this.addUserToGroup(gn, user);
                }
            }
        }
    }

    public void readGroupString(String fileContent) {
        this.groupPath = null;
        this.groupLastModified = null;
        this.htGroups.clear();
        try {
            this.readGroupReader(new StringReader(fileContent));
            log.info("Successfully read groups from group file [{}]", (Object)fileContent);
        }
        catch (Exception e) {
            log.error("Failed to read group file [{}]", (Object)fileContent, (Object)e);
        }
    }

    public void readGroupPath(Path file) {
        block11: {
            this.groupPath = file;
            this.htGroups.clear();
            try {
                if (this.groupPath != null && Files.exists(this.groupPath, new LinkOption[0])) {
                    this.groupLastModified = Files.getLastModifiedTime(this.groupPath, new LinkOption[0]);
                    try (BufferedReader reader = Files.newBufferedReader(file, StandardCharsets.UTF_8);){
                        this.readGroupReader(reader);
                        log.info("Successfully read groups from group file [{}]", (Object)this.groupPath);
                        break block11;
                    }
                    catch (Exception e) {
                        log.error("Failed to read group file [{}]", (Object)this.groupPath, (Object)e);
                    }
                    break block11;
                }
                log.warn("group file [{}] does not exist.", (Object)this.groupPath);
                this.groupLastModified = null;
            }
            catch (Exception e) {
                log.error("Failed to check group file [" + String.valueOf(this.groupPath) + "]", (Throwable)e);
                this.groupLastModified = null;
            }
        }
    }

    private void readClaimsReader(Reader reader) throws StreamReadException, DatabindException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        TypeReference<Map<String, Map<String, String>>> typeRef = new TypeReference<Map<String, Map<String, String>>>(){};
        Map claims = (Map)mapper.readValue(reader, (TypeReference)typeRef);
        this.htClaims.putAll(claims);
    }

    public void readClaimsString(String fileContent) {
        this.claimsPath = null;
        this.claimsLastModified = null;
        this.htClaims.clear();
        try {
            this.readClaimsReader(new StringReader(fileContent));
            log.info("Successfully read [{}] entries from claims file [{}]", (Object)this.htClaims.size(), (Object)fileContent);
        }
        catch (Exception e) {
            log.error("Failed to read claims file [{}]", (Object)fileContent, (Object)e);
        }
    }

    public void readClaimsPath(Path file) {
        block11: {
            this.claimsPath = file;
            this.htClaims.clear();
            try {
                if (this.claimsPath != null && Files.exists(this.claimsPath, new LinkOption[0])) {
                    this.claimsLastModified = Files.getLastModifiedTime(this.claimsPath, new LinkOption[0]);
                    try (BufferedReader reader = Files.newBufferedReader(file, StandardCharsets.UTF_8);){
                        this.readClaimsReader(reader);
                        log.info("Successfully read [{}] entries from claims file [{}]", (Object)this.htClaims.size(), (Object)this.claimsPath);
                        break block11;
                    }
                    catch (Exception e) {
                        log.error("Failed to read claims file [{}]", (Object)this.claimsPath, (Object)e);
                    }
                    break block11;
                }
                log.warn("claims file [{}] does not exist.", (Object)this.claimsPath);
                this.claimsLastModified = null;
            }
            catch (Exception e) {
                log.error("Failed to check claims file [" + String.valueOf(this.claimsPath) + "]", (Throwable)e);
                this.claimsLastModified = null;
            }
        }
    }

    public int getNumberHtpasswdUsers() {
        return this.htUsers.size();
    }

    private final boolean modifiedAfter(Path path, FileTime instant) {
        if (instant == null) {
            return true;
        }
        try {
            FileTime lastMod = Files.getLastModifiedTime(path, new LinkOption[0]);
            return lastMod.compareTo(instant) > 0;
        }
        catch (IOException e) {
            log.warn("Failed to check file [{}], keeping old content", (Object)path, (Object)e);
            return false;
        }
    }

    public boolean needsUpdate() {
        if (this.htpasswdPath == null) {
            return false;
        }
        if (Files.exists(this.htpasswdPath, new LinkOption[0]) ? this.modifiedAfter(this.htpasswdPath, this.lastModified) : this.lastModified != null) {
            return true;
        }
        if (this.groupPath == null) {
            return false;
        }
        if (Files.exists(this.groupPath, new LinkOption[0]) ? this.modifiedAfter(this.groupPath, this.groupLastModified) : this.groupLastModified != null) {
            return true;
        }
        if (this.claimsPath == null) {
            return false;
        }
        if (Files.exists(this.claimsPath, new LinkOption[0])) {
            return this.modifiedAfter(this.claimsPath, this.claimsLastModified);
        }
        return this.claimsLastModified != null;
    }

    public Path getHtpasswdPath() {
        return this.htpasswdPath;
    }

    public Path getGroupPath() {
        return this.groupPath;
    }

    public Path getClaimsPath() {
        return this.claimsPath;
    }

    public FileTime getLastModified() {
        return this.lastModified;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + String.valueOf(this.htpasswdPath) + "]";
    }
}

