/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.util.sec;

import org.clazzes.util.sec.HashTools;
import org.clazzes.util.sec.PasswordHasher;

public class PlainPasswordHasher
implements PasswordHasher {
    protected final String algo_prefix = "{" + this.getAlgorithmName() + "}";

    @Override
    public String hashPassword(String cleartext) {
        return this.hashPassword(cleartext, HashTools.randomSalt());
    }

    @Override
    public String hashPassword(String cleartext, String salt) {
        return this.algo_prefix + cleartext;
    }

    @Override
    public boolean checkPassword(String cleartext, String hashed) {
        return cleartext.equals(this.stripAlgorithmKey(hashed));
    }

    @Override
    public String getAlgorithmName() {
        return "PLAIN";
    }

    public String getAlgorithmPrefix() {
        return this.algo_prefix;
    }

    protected String stripAlgorithmKey(String from_password) {
        if (from_password == null) {
            return null;
        }
        if (from_password.startsWith(this.algo_prefix)) {
            String s = from_password.substring(this.algo_prefix.length());
            return s;
        }
        return from_password;
    }

    protected String prependAlgorithmKey(String to_password) {
        if (to_password == null) {
            return null;
        }
        if (to_password.startsWith(this.algo_prefix)) {
            return to_password;
        }
        return this.algo_prefix + to_password;
    }

    @Override
    public int getSaltLength() {
        return 0;
    }
}

