/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.util.sec;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.clazzes.util.sec.BCryptPasswordHasher;
import org.clazzes.util.sec.CryptPasswordHasher;
import org.clazzes.util.sec.PasswordHasher;
import org.clazzes.util.sec.PasswordHasherFactory;
import org.clazzes.util.sec.PlainPasswordHasher;
import org.clazzes.util.sec.SSHA1PasswordHasher;

public class HasherFactory
implements PasswordHasherFactory {
    private final Map<String, PasswordHasher> hashers_byname = new HashMap<String, PasswordHasher>();

    public HasherFactory() {
        PlainPasswordHasher plain_hasher = new PlainPasswordHasher();
        this.hashers_byname.put(plain_hasher.getAlgorithmName().toUpperCase(Locale.ENGLISH), plain_hasher);
        SSHA1PasswordHasher sha1_hasher = new SSHA1PasswordHasher();
        this.hashers_byname.put(sha1_hasher.getAlgorithmName().toUpperCase(Locale.ENGLISH), sha1_hasher);
        CryptPasswordHasher crypt_hasher = new CryptPasswordHasher();
        this.hashers_byname.put(crypt_hasher.getAlgorithmName().toUpperCase(Locale.ENGLISH), crypt_hasher);
        BCryptPasswordHasher bcrypt_hasher = new BCryptPasswordHasher();
        this.hashers_byname.put(bcrypt_hasher.getAlgorithmName().toUpperCase(Locale.ENGLISH), bcrypt_hasher);
    }

    @Override
    public PasswordHasher getPasswordHasher(String algo_name) {
        if (algo_name == null) {
            return null;
        }
        PasswordHasher hasher = this.hashers_byname.get(algo_name.toUpperCase(Locale.ENGLISH));
        return hasher;
    }

    @Override
    public Collection<PasswordHasher> getKnownPasswordHashers() {
        return Collections.unmodifiableCollection(this.hashers_byname.values());
    }
}

