/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.util.sec;

import java.security.SecureRandom;
import org.clazzes.util.sec.HashTools;
import org.clazzes.util.sec.PasswordHasher;
import org.mindrot.jbcrypt.BCrypt;

public class BCryptPasswordHasher
implements PasswordHasher {
    private final int logRounds;

    public BCryptPasswordHasher(int logRounds) {
        this.logRounds = logRounds;
    }

    public BCryptPasswordHasher() {
        this(10);
    }

    @Override
    public String hashPassword(String cleartext) {
        String salt = BCrypt.gensalt((int)this.logRounds, (SecureRandom)HashTools.getSecureRandom());
        return this.hashPassword(cleartext, salt);
    }

    @Override
    public String hashPassword(String cleartext, String salt) {
        return "{BCRYPT}" + BCrypt.hashpw((String)cleartext, (String)salt);
    }

    @Override
    public boolean checkPassword(String cleartext, String hashed) {
        if (hashed.startsWith("{BCRYPT}")) {
            return BCrypt.checkpw((String)cleartext, (String)hashed.substring(8));
        }
        return false;
    }

    @Override
    public String getAlgorithmName() {
        return "BCRYPT";
    }

    @Override
    public int getSaltLength() {
        return 29;
    }
}

