/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.util.ryu;

import java.math.BigInteger;
import java.text.DecimalFormatSymbols;
import java.util.Objects;
import org.clazzes.util.lang.Util;
import org.clazzes.util.ryu.RoundingMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RyuFloat {
    private static final Logger log = LoggerFactory.getLogger(RyuFloat.class);
    private static final int FLOAT_MANTISSA_BITS = 23;
    private static final int FLOAT_MANTISSA_MASK = 0x7FFFFF;
    private static final int FLOAT_EXPONENT_BITS = 8;
    private static final int FLOAT_EXPONENT_MASK = 255;
    private static final int FLOAT_EXPONENT_BIAS = 127;
    private static final long LOG10_2_DENOMINATOR = 10000000L;
    private static final long LOG10_2_NUMERATOR = (long)(1.0E7 * Math.log10(2.0));
    private static final long LOG10_5_DENOMINATOR = 10000000L;
    private static final long LOG10_5_NUMERATOR = (long)(1.0E7 * Math.log10(5.0));
    private static final long LOG2_5_DENOMINATOR = 10000000L;
    private static final long LOG2_5_NUMERATOR = (long)(1.0E7 * (Math.log(5.0) / Math.log(2.0)));
    private static final int POS_TABLE_SIZE = 47;
    private static final int INV_TABLE_SIZE = 31;
    private static final BigInteger[] POW5 = new BigInteger[47];
    private static final BigInteger[] POW5_INV = new BigInteger[31];
    private static final int POW5_BITCOUNT = 61;
    private static final int POW5_HALF_BITCOUNT = 31;
    private static final int[][] POW5_SPLIT = new int[47][2];
    private static final int POW5_INV_BITCOUNT = 59;
    private static final int POW5_INV_HALF_BITCOUNT = 31;
    private static final int[][] POW5_INV_SPLIT = new int[31][2];

    public static DecimalMantExp extractDecimalMantExp(float value, RoundingMode roundingMode) {
        boolean dmIsTrailingZeros;
        boolean dvIsTrailingZeros;
        boolean dpIsTrailingZeros;
        int dm;
        int dp;
        int dv;
        int e10;
        boolean sign;
        int m2;
        int e2;
        if (Float.isNaN(value) || Float.isInfinite(value)) {
            throw new IllegalArgumentException("Argument was NaN or Infinity.");
        }
        int bits = Float.floatToIntBits(value);
        if (bits == 0) {
            return new DecimalMantExp(false, 0, 0);
        }
        if (bits == Integer.MIN_VALUE) {
            return new DecimalMantExp(true, 0, 0);
        }
        int ieeeExponent = bits >> 23 & 0xFF;
        int ieeeMantissa = bits & 0x7FFFFF;
        if (ieeeExponent == 0) {
            e2 = -149;
            m2 = ieeeMantissa;
        } else {
            e2 = ieeeExponent - 127 - 23;
            m2 = ieeeMantissa | 0x800000;
        }
        boolean bl = sign = bits < 0;
        if (log.isDebugEnabled()) {
            log.debug("IN=" + Long.toBinaryString(bits));
            log.debug("   S=" + (sign ? "-" : "+") + " E=" + e2 + " M=" + m2);
        }
        boolean even = (m2 & 1) == 0;
        int mv = 4 * m2;
        int mp = 4 * m2 + 2;
        int mm = 4 * m2 - ((long)m2 != 0x800000L || ieeeExponent <= 1 ? 2 : 1);
        e2 -= 2;
        if (log.isDebugEnabled()) {
            String sm;
            String sp;
            String sv;
            if (e2 >= 0) {
                sv = BigInteger.valueOf(mv).shiftLeft(e2).toString();
                sp = BigInteger.valueOf(mp).shiftLeft(e2).toString();
                sm = BigInteger.valueOf(mm).shiftLeft(e2).toString();
                e10 = 0;
            } else {
                BigInteger factor = BigInteger.valueOf(5L).pow(-e2);
                sv = BigInteger.valueOf(mv).multiply(factor).toString();
                sp = BigInteger.valueOf(mp).multiply(factor).toString();
                sm = BigInteger.valueOf(mm).multiply(factor).toString();
                e10 = e2;
            }
            log.debug("Exact values");
            log.debug("  m =" + mv);
            log.debug("  E =" + (e10 += sp.length() - 1));
            log.debug("  d+=" + sp);
            log.debug("  d =" + sv);
            log.debug("  d-=" + sm);
            log.debug("  e2=" + e2);
        }
        int lastRemovedDigit = 0;
        if (e2 >= 0) {
            q = (int)((long)e2 * LOG10_2_NUMERATOR / 10000000L);
            int k = 59 + RyuFloat.pow5bits(q) - 1;
            int i = -e2 + q + k;
            dv = (int)RyuFloat.mulPow5InvDivPow2(mv, q, i);
            dp = (int)RyuFloat.mulPow5InvDivPow2(mp, q, i);
            dm = (int)RyuFloat.mulPow5InvDivPow2(mm, q, i);
            if (q != 0 && (dp - 1) / 10 <= dm / 10) {
                int l = 59 + RyuFloat.pow5bits(q - 1) - 1;
                lastRemovedDigit = (int)(RyuFloat.mulPow5InvDivPow2(mv, q - 1, -e2 + q - 1 + l) % 10L);
            }
            e10 = q;
            if (log.isDebugEnabled()) {
                log.debug(mv + " * 2^" + e2 + " / 10^" + q);
            }
            dpIsTrailingZeros = RyuFloat.pow5Factor(mp) >= q;
            dvIsTrailingZeros = RyuFloat.pow5Factor(mv) >= q;
            dmIsTrailingZeros = RyuFloat.pow5Factor(mm) >= q;
        } else {
            q = (int)((long)(-e2) * LOG10_5_NUMERATOR / 10000000L);
            int i = -e2 - q;
            int k = RyuFloat.pow5bits(i) - 61;
            int j = q - k;
            dv = (int)RyuFloat.mulPow5divPow2(mv, i, j);
            dp = (int)RyuFloat.mulPow5divPow2(mp, i, j);
            dm = (int)RyuFloat.mulPow5divPow2(mm, i, j);
            if (q != 0 && (dp - 1) / 10 <= dm / 10) {
                j = q - 1 - (RyuFloat.pow5bits(i + 1) - 61);
                lastRemovedDigit = (int)(RyuFloat.mulPow5divPow2(mv, i + 1, j) % 10L);
            }
            e10 = q + e2;
            if (log.isDebugEnabled()) {
                log.debug(mv + " * 5^" + -e2 + " / 10^" + q + " = " + mv + " * 5^" + (-e2 - q) + " / 2^" + q);
            }
            dpIsTrailingZeros = 1 >= q;
            dvIsTrailingZeros = q < 23 && (mv & (1 << q - 1) - 1) == 0;
            boolean bl2 = dmIsTrailingZeros = (mm % 2 == 1 ? 0 : 1) >= q;
        }
        if (log.isDebugEnabled()) {
            log.debug("Actual values");
            log.debug("  d+=" + dp);
            log.debug("  d =" + dv);
            log.debug("  d-=" + dm);
            log.debug("  last removed=" + lastRemovedDigit);
            log.debug("  e10=" + e10);
            log.debug("  d+10=" + dpIsTrailingZeros);
            log.debug("  d   =" + dvIsTrailingZeros);
            log.debug("  d-10=" + dmIsTrailingZeros);
        }
        int dplength = Util.decimalLength(dp);
        int exp = e10 + dplength - 1;
        int removed = 0;
        if (dpIsTrailingZeros && !roundingMode.acceptUpperBound(even)) {
            --dp;
        }
        while (dp / 10 > dm / 10) {
            dmIsTrailingZeros &= dm % 10 == 0;
            dp /= 10;
            lastRemovedDigit = dv % 10;
            dv /= 10;
            dm /= 10;
            ++removed;
        }
        if (dmIsTrailingZeros && roundingMode.acceptLowerBound(even)) {
            while (dm % 10 == 0) {
                dp /= 10;
                lastRemovedDigit = dv % 10;
                dv /= 10;
                dm /= 10;
                ++removed;
            }
        }
        if (dvIsTrailingZeros && lastRemovedDigit == 5 && dv % 2 == 0) {
            lastRemovedDigit = 4;
        }
        int output = dv + (dv == dm && (!dmIsTrailingZeros || !roundingMode.acceptLowerBound(even)) || lastRemovedDigit >= 5 ? 1 : 0);
        int olength = dplength - removed;
        if (log.isDebugEnabled()) {
            log.debug("Actual values after loop");
            log.debug("  d+=" + dp);
            log.debug("  d =" + dv);
            log.debug("  d-=" + dm);
            log.debug("  last removed=" + lastRemovedDigit);
            log.debug("  e10=" + e10);
            log.debug("  d+10=" + dpIsTrailingZeros);
            log.debug("  d-10=" + dmIsTrailingZeros);
            log.debug("  output=" + output);
            log.debug("  output_length=" + olength);
            log.debug("  output_exponent=" + exp);
        }
        return new DecimalMantExp(sign, output, exp);
    }

    public static void floatToString(StringBuffer sb, float value, DecimalFormatSymbols syms, RoundingMode roundingMode, int options) {
        if (Float.isNaN(value)) {
            sb.append(syms.getNaN());
            return;
        }
        if (value == Float.POSITIVE_INFINITY) {
            sb.append(syms.getInfinity());
            return;
        }
        if (value == Float.NEGATIVE_INFINITY) {
            sb.append(syms.getMinusSign());
            sb.append(syms.getInfinity());
            return;
        }
        boolean showDotZero = (options & 1) != 0;
        boolean forceScientific = (options & 2) != 0;
        DecimalMantExp decMantExpr = RyuFloat.extractDecimalMantExp(value, roundingMode);
        boolean sign = decMantExpr.sign;
        int output = decMantExpr.mantissa;
        int exp = decMantExpr.exponent;
        if (output == 0 && exp == 0) {
            if (sign) {
                sb.append(syms.getMinusSign());
            }
            sb.append('0');
            if (showDotZero) {
                sb.append(syms.getDecimalSeparator());
                sb.append('0');
            }
            if (forceScientific) {
                sb.append(syms.getExponentSeparator());
                sb.append('0');
            }
            return;
        }
        boolean scientificNotation = forceScientific || exp < -3 || exp >= 7;
        int olength = Util.decimalLength(output);
        char[] result = new char[15];
        int index = 0;
        if (sign) {
            result[index++] = syms.getMinusSign();
        }
        if (scientificNotation) {
            for (int i = 0; i < olength - 1; ++i) {
                int c = output % 10;
                output /= 10;
                result[index + olength - i] = (char)(48 + c);
            }
            result[index] = (char)(48 + output % 10);
            if (showDotZero || olength > 1) {
                result[index + 1] = syms.getDecimalSeparator();
                index += olength + 1;
                if (olength == 1) {
                    result[index++] = 48;
                }
            } else {
                index += olength;
            }
            sb.append(result, 0, index);
            index = 0;
            sb.append(syms.getExponentSeparator());
            if (exp < 0) {
                result[index++] = syms.getMinusSign();
                exp = -exp;
            }
            if (exp >= 10) {
                result[index++] = (char)(48 + exp / 10);
            }
            result[index++] = (char)(48 + exp % 10);
        } else if (exp < 0) {
            result[index++] = 48;
            result[index++] = syms.getDecimalSeparator();
            for (int i = -1; i > exp; --i) {
                result[index++] = 48;
            }
            int current = index;
            for (int i = 0; i < olength; ++i) {
                result[current + olength - i - 1] = (char)(48 + output % 10);
                output /= 10;
                ++index;
            }
        } else if (exp + 1 >= olength) {
            int i;
            for (i = 0; i < olength; ++i) {
                result[index + olength - i - 1] = (char)(48 + output % 10);
                output /= 10;
            }
            index += olength;
            for (i = olength; i < exp + 1; ++i) {
                result[index++] = 48;
            }
            if (showDotZero) {
                result[index++] = syms.getDecimalSeparator();
                result[index++] = 48;
            }
        } else {
            int current = index + 1;
            for (int i = 0; i < olength; ++i) {
                if (olength - i - 1 == exp) {
                    result[current + olength - i - 1] = syms.getDecimalSeparator();
                    --current;
                }
                result[current + olength - i - 1] = (char)(48 + output % 10);
                output /= 10;
            }
            index += olength + 1;
        }
        sb.append(result, 0, index);
    }

    private static int pow5bits(int e) {
        return e == 0 ? 1 : (int)(((long)e * LOG2_5_NUMERATOR + 10000000L - 1L) / 10000000L);
    }

    private static int pow5Factor(int value) {
        int count = 0;
        while (value > 0) {
            if (value % 5 != 0) {
                return count;
            }
            value /= 5;
            ++count;
        }
        throw new IllegalArgumentException("" + value);
    }

    private static long mulPow5divPow2(int m, int i, int j) {
        if (j - 31 < 0) {
            throw new IllegalArgumentException();
        }
        long bits0 = (long)m * (long)POW5_SPLIT[i][0];
        long bits1 = (long)m * (long)POW5_SPLIT[i][1];
        return bits0 + (bits1 >> 31) >> j - 31;
    }

    private static long mulPow5InvDivPow2(int m, int q, int j) {
        if (j - 31 < 0) {
            throw new IllegalArgumentException();
        }
        long bits0 = (long)m * (long)POW5_INV_SPLIT[q][0];
        long bits1 = (long)m * (long)POW5_INV_SPLIT[q][1];
        return bits0 + (bits1 >> 31) >> j - 31;
    }

    static {
        BigInteger mask = BigInteger.valueOf(1L).shiftLeft(31).subtract(BigInteger.ONE);
        BigInteger maskInv = BigInteger.valueOf(1L).shiftLeft(31).subtract(BigInteger.ONE);
        for (int i = 0; i < Math.max(POW5.length, POW5_INV.length); ++i) {
            BigInteger inv;
            BigInteger pow = BigInteger.valueOf(5L).pow(i);
            int pow5len = pow.bitLength();
            int expectedPow5Bits = RyuFloat.pow5bits(i);
            if (expectedPow5Bits != pow5len) {
                throw new IllegalStateException(pow5len + " != " + expectedPow5Bits);
            }
            if (i < POW5.length) {
                RyuFloat.POW5[i] = pow;
            }
            if (i < POW5_SPLIT.length) {
                RyuFloat.POW5_SPLIT[i][0] = pow.shiftRight(pow5len - 61 + 31).intValueExact();
                RyuFloat.POW5_SPLIT[i][1] = pow.shiftRight(pow5len - 61).and(mask).intValueExact();
            }
            if (i >= POW5_INV.length) continue;
            int j = pow5len - 1 + 59;
            RyuFloat.POW5_INV[i] = inv = BigInteger.ONE.shiftLeft(j).divide(pow).add(BigInteger.ONE);
            RyuFloat.POW5_INV_SPLIT[i][0] = inv.shiftRight(31).intValueExact();
            RyuFloat.POW5_INV_SPLIT[i][1] = inv.and(maskInv).intValueExact();
        }
    }

    public static class DecimalMantExp {
        public final boolean sign;
        public final int mantissa;
        public final int exponent;

        public DecimalMantExp(boolean sign, int mantissa, int exponent) {
            this.sign = sign;
            this.mantissa = mantissa;
            this.exponent = exponent;
        }

        public int hashCode() {
            return Objects.hash(this.exponent, this.mantissa, this.sign);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DecimalMantExp other = (DecimalMantExp)obj;
            return this.exponent == other.exponent && this.mantissa == other.mantissa && this.sign == other.sign;
        }

        public String toString() {
            return "DecimalMantExp [sign=" + this.sign + ", mantissa=" + this.mantissa + ", exponent=" + this.exponent + "]";
        }
    }
}

