/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.util.net;

public class NetUtil {
    private NetUtil() {
    }

    public static long ipString2Long(String ip) {
        String[] octets = ip.split("\\.");
        long nr = Long.valueOf(octets[0]) << 24 | Long.valueOf(octets[1]) << 16 | Long.valueOf(octets[2]) << 8 | Long.valueOf(octets[3]);
        return nr;
    }

    public static String ipLong2String(long nr) {
        String ip = String.valueOf((nr & 0xFFFFFFFFFF000000L) >> 24) + "." + String.valueOf((nr & 0xFF0000L) >> 16) + "." + String.valueOf((nr & 0xFF00L) >> 8) + "." + String.valueOf(nr & 0xFFL);
        return ip;
    }

    public static boolean isValidIPv4(String ip) {
        if (!ip.matches("[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}")) {
            return false;
        }
        String[] octets = ip.split("\\.");
        int i0 = Integer.valueOf(octets[0]);
        int i1 = Integer.valueOf(octets[1]);
        int i2 = Integer.valueOf(octets[2]);
        int i3 = Integer.valueOf(octets[3]);
        if (i0 < 0 || i0 > 255) {
            return false;
        }
        if (i1 < 0 || i1 > 255) {
            return false;
        }
        if (i2 < 0 || i2 > 255) {
            return false;
        }
        return i3 >= 0 && i3 <= 255;
    }
}

