/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.util.lang;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.clazzes.util.lang.MappedCollection;
import org.clazzes.util.lang.MappedIterator;
import org.clazzes.util.lang.MappedSet;

public class MappedMap<K, KM, V, VM>
extends AbstractMap<KM, VM> {
    private final Map<K, V> underlying;
    private final Function<V, VM> valueMapper;
    private final Function<K, KM> keyMapper;
    private final Function<Object, Object> reverseKeyMapper;

    private MappedMap(Map<K, V> underlying, Function<V, VM> valueMapper, Function<K, KM> keyMapper, Function<Object, Object> reverseKeyMapper) {
        this.underlying = underlying;
        this.valueMapper = valueMapper;
        this.keyMapper = keyMapper;
        this.reverseKeyMapper = reverseKeyMapper;
    }

    @Override
    public boolean containsKey(Object arg0) {
        return this.underlying.containsKey(this.reverseKeyMapper.apply(arg0));
    }

    @Override
    public boolean containsValue(Object arg0) {
        return this.values().contains(arg0);
    }

    @Override
    public Set<Map.Entry<KM, VM>> entrySet() {
        return new AbstractSet<Map.Entry<KM, VM>>(){
            Set<Map.Entry<K, V>> underlyingSet;
            Function<Map.Entry<K, V>, Map.Entry<KM, VM>> entryMapper;
            {
                this.underlyingSet = MappedMap.this.underlying.entrySet();
                this.entryMapper = entry -> new AbstractMap.SimpleImmutableEntry(MappedMap.this.keyMapper.apply(entry.getKey()), MappedMap.this.valueMapper.apply(entry.getValue()));
            }

            @Override
            public boolean contains(Object arg0) {
                if (!(arg0 instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)arg0;
                Object mappedKey = MappedMap.this.reverseKeyMapper.apply(entry.getKey());
                if (!MappedMap.this.underlying.containsKey(mappedKey)) {
                    return false;
                }
                Object value = MappedMap.this.valueMapper.apply(MappedMap.this.underlying.get(mappedKey));
                return Objects.equals(value, entry.getValue());
            }

            @Override
            public Iterator<Map.Entry<KM, VM>> iterator() {
                return new MappedIterator(this.underlyingSet.iterator(), this.entryMapper);
            }

            @Override
            public int size() {
                return this.underlyingSet.size();
            }
        };
    }

    @Override
    public VM get(Object arg0) {
        Object mappedKey = this.reverseKeyMapper.apply(arg0);
        if (!this.underlying.containsKey(mappedKey)) {
            return null;
        }
        return this.valueMapper.apply(this.underlying.get(mappedKey));
    }

    @Override
    public Set<KM> keySet() {
        return MappedSet.newInstance(this.underlying.keySet(), this.keyMapper, this.reverseKeyMapper);
    }

    @Override
    public int size() {
        return this.underlying.size();
    }

    @Override
    public Collection<VM> values() {
        return MappedCollection.newInstance(this.underlying.values(), this.valueMapper);
    }

    public static <K, V, VM> MappedMap<K, K, V, VM> newInstance(Map<K, V> underlying, Function<V, VM> valueMapper) {
        return new MappedMap(underlying, valueMapper, Function.identity(), Function.identity());
    }

    public static <K, KM, V, VM> MappedMap<K, KM, V, VM> newInstance(Map<K, V> underlying, Function<V, VM> valueMapper, Function<K, KM> keyMapper, Function<Object, Object> reverseKeyMapper) {
        return new MappedMap<K, KM, V, VM>(underlying, valueMapper, keyMapper, reverseKeyMapper);
    }
}

