/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.util.lang;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Function;
import org.clazzes.util.lang.MappedIterator;

public class MappedCollection<P, T>
extends AbstractCollection<T> {
    private Collection<P> underlying;
    private Function<P, T> mapper;

    public MappedCollection(Collection<P> underlying, Function<P, T> mapper) {
        Objects.requireNonNull(underlying);
        Objects.requireNonNull(mapper);
        this.underlying = underlying;
        this.mapper = mapper;
    }

    public static <P, T> MappedCollection<P, T> newInstance(Collection<P> underlying, Function<P, T> mapper) {
        return new MappedCollection<P, T>(underlying, mapper);
    }

    @Override
    public Iterator<T> iterator() {
        return new MappedIterator<P, T>(this.underlying.iterator(), this.mapper);
    }

    @Override
    public int size() {
        return this.underlying.size();
    }

    public Collection<P> getUnderlying() {
        return this.underlying;
    }
}

