/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.util.formula;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public abstract class FormulaHelper {
    public static final List<String> BUILTIN_FUNCTIONS = Collections.unmodifiableList(Arrays.asList("abs", "signum", "sin", "cos", "tan", "asin", "acos", "atan", "sqrt", "log", "log10", "exp"));

    public static double callBuiltin(String f, double x) {
        switch (f) {
            case "abs": {
                return Math.abs(x);
            }
            case "signum": {
                return Math.signum(x);
            }
            case "sqrt": {
                return Math.sqrt(x);
            }
            case "sin": {
                return Math.sin(x);
            }
            case "cos": {
                return Math.cos(x);
            }
            case "tan": {
                return Math.tan(x);
            }
            case "asin": {
                return Math.asin(x);
            }
            case "acos": {
                return Math.acos(x);
            }
            case "atan": {
                return Math.atan(x);
            }
            case "log": {
                return Math.log(x);
            }
            case "log10": {
                return Math.log10(x);
            }
            case "exp": {
                return Math.exp(x);
            }
        }
        throw new IllegalArgumentException("Unknown builtin function [" + f + "].");
    }

    public static double booleanToDouble(boolean b) {
        return b ? 1.0 : 0.0;
    }

    public static boolean isRightAssociative(int precedence) {
        return precedence == 1 || precedence == 8;
    }

    public static boolean needLeftBraces(int parentPrecedence, int childPrecedence) {
        if (parentPrecedence < 0 || childPrecedence < 0) {
            return false;
        }
        if (childPrecedence < parentPrecedence) {
            return true;
        }
        if (childPrecedence > parentPrecedence) {
            return false;
        }
        return FormulaHelper.isRightAssociative(parentPrecedence);
    }

    public static boolean needRightBraces(int parentPrecedence, int childPrecedence) {
        if (parentPrecedence < 0 || childPrecedence < 0) {
            return false;
        }
        if (childPrecedence < parentPrecedence) {
            return true;
        }
        if (childPrecedence > parentPrecedence) {
            return false;
        }
        return !FormulaHelper.isRightAssociative(parentPrecedence);
    }
}

