/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.util.datetime;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.persistence.Embeddable;
import javax.persistence.Transient;
import org.clazzes.util.datetime.UtcTimestamp;

@Embeddable
public class GlobalDate
implements Comparable<GlobalDate>,
Serializable {
    private static final long serialVersionUID = -2458688803800920831L;
    protected int year;
    protected int month;
    protected int day;
    protected Integer yyyymmdd;

    public GlobalDate() {
        this.setDate(0, 0, 0);
    }

    public GlobalDate(int year, int month, int day) {
        this.setDate(year, month, day);
    }

    public GlobalDate(Date date) {
        this.setDate(date);
    }

    public GlobalDate(Calendar calendar) {
        this.setDate(calendar);
    }

    public GlobalDate(UtcTimestamp utcTimestamp) {
        this.setDate(utcTimestamp);
    }

    public GlobalDate(long utcMillis) {
        this.setDate(utcMillis);
    }

    public GlobalDate(int yyyymmdd) {
        this.setYyyymmdd(yyyymmdd);
    }

    protected void ymd2yyyymmdd() {
        this.yyyymmdd = this.year * 10000 + this.month * 100 + this.day;
    }

    protected void yyyymmdd2ymd() {
        this.year = this.yyyymmdd / 10000;
        int mmdd = this.yyyymmdd - this.year * 10000;
        this.month = mmdd / 100;
        this.day = mmdd - this.month * 100;
    }

    @Transient
    public void setDate(int year, int month, int day) {
        this.year = year;
        this.month = month;
        this.day = day;
        this.ymd2yyyymmdd();
    }

    public Date toDate() {
        return this.toCalendar().getTime();
    }

    public Calendar toCalendar() {
        return new GregorianCalendar(this.year, this.month - 1, this.day);
    }

    public UtcTimestamp toUtcTimestamp() {
        return new UtcTimestamp(this.toCalendar());
    }

    public long toMillis() {
        return this.toCalendar().getTimeInMillis();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append((Object)this.year);
        sb.append('-');
        sb.append((char)(this.month / 10 + 48));
        sb.append((char)(this.month % 10 + 48));
        sb.append('-');
        sb.append((char)(this.day / 10 + 48));
        sb.append((char)(this.day % 10 + 48));
        return sb.toString();
    }

    @Transient
    public void setDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        this.setDate(calendar);
    }

    @Transient
    public void setDate(Calendar calendar) {
        this.setDate(calendar.get(1), calendar.get(2) + 1, calendar.get(5));
    }

    @Transient
    public void setDate(UtcTimestamp utcTimestamp) {
        this.setDate(utcTimestamp.getYear(), utcTimestamp.getMonth(), utcTimestamp.getDay());
    }

    @Transient
    public void setDate(long utcMillis) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(utcMillis);
        this.setDate(calendar);
    }

    public Integer getYyyymmdd() {
        return this.yyyymmdd;
    }

    public void setYyyymmdd(Integer yyyymmdd) {
        this.yyyymmdd = yyyymmdd;
        this.yyyymmdd2ymd();
    }

    @Transient
    public int getYear() {
        return this.year;
    }

    @Transient
    public void setYear(int year) {
        this.year = year;
        this.ymd2yyyymmdd();
    }

    @Transient
    public int getMonth() {
        return this.month;
    }

    @Transient
    public void setMonth(int month) {
        this.month = month;
        this.ymd2yyyymmdd();
    }

    @Transient
    public int getDay() {
        return this.day;
    }

    @Transient
    public void setDay(int day) {
        this.day = day;
        this.ymd2yyyymmdd();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.yyyymmdd;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GlobalDate other = (GlobalDate)obj;
        return this.yyyymmdd.equals((int)other.yyyymmdd);
    }

    @Override
    public int compareTo(GlobalDate o) {
        if (o == null) {
            throw new NullPointerException("compareTo(GlobalDate other): other==null");
        }
        return Integer.valueOf(this.yyyymmdd).compareTo(o.getYyyymmdd());
    }

    public boolean before(GlobalDate other) {
        if (other == null) {
            throw new NullPointerException("before(GlobalDate other): other==null");
        }
        return this.yyyymmdd < other.getYyyymmdd();
    }

    public boolean after(GlobalDate other) {
        if (other == null) {
            throw new NullPointerException("after(GlobalDate other): other==null");
        }
        return this.yyyymmdd > other.getYyyymmdd();
    }
}

