/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.util.datetime;

import java.util.Calendar;
import java.util.Comparator;

public abstract class CalendarHelper {
    public static Comparator<Calendar> DATE_ONLY_COMPARATOR = new Comparator<Calendar>(){

        @Override
        public int compare(Calendar c1, Calendar c2) {
            int r = c1.get(1) - c2.get(1);
            if (r != 0) {
                return r;
            }
            return c1.get(6) - c2.get(6);
        }
    };

    public static int daysBetween(Calendar c1, Calendar c2) {
        int yearDays;
        block3: {
            int y2;
            int y1;
            block2: {
                yearDays = 0;
                y1 = c1.get(1);
                y2 = c2.get(1);
                if (y2 <= y1) break block2;
                Calendar c = (Calendar)c1.clone();
                while (c.get(1) < y2) {
                    yearDays += c.getActualMaximum(6);
                    c.add(1, 1);
                }
                break block3;
            }
            if (y2 >= y1) break block3;
            Calendar c = (Calendar)c2.clone();
            while (c.get(1) < y1) {
                yearDays -= c.getActualMaximum(6);
                c.add(1, 1);
            }
        }
        return yearDays + c2.get(6) - c1.get(6);
    }

    public static int weeksBetween(Calendar c1, Calendar c2, int firstDayOfWeek) {
        int days = CalendarHelper.daysBetween(c1, c2);
        int w1 = c1.get(7);
        int w2 = c2.get(7);
        days += (7 + w1 - firstDayOfWeek) % 7;
        assert ((days -= (7 + w2 - firstDayOfWeek) % 7) % 7 == 0);
        return days / 7;
    }

    public static void moveToFirstDayOfWeek(Calendar c, int firstDayOfWeek) {
        int w = c.get(7);
        c.add(6, -(7 + w - firstDayOfWeek) % 7);
    }

    public static void moveToFirstDayOfWeek(Calendar c) {
        CalendarHelper.moveToFirstDayOfWeek(c, c.getFirstDayOfWeek());
    }

    public static Calendar cloneToFirstDayOfWeek(Calendar c, int firstDayOfWeek) {
        Calendar ret = (Calendar)c.clone();
        CalendarHelper.moveToFirstDayOfWeek(ret, firstDayOfWeek);
        return ret;
    }

    public static Calendar cloneToFirstDayOfWeek(Calendar c) {
        return CalendarHelper.cloneToFirstDayOfWeek(c, c.getFirstDayOfWeek());
    }

    public static int monthsBetween(Calendar c1, Calendar c2) {
        int yearDays;
        block3: {
            int y2;
            int y1;
            block2: {
                yearDays = 0;
                y1 = c1.get(1);
                y2 = c2.get(1);
                if (y2 <= y1) break block2;
                Calendar c = (Calendar)c1.clone();
                while (c.get(1) < y2) {
                    yearDays += c.getActualMaximum(2) + 1;
                    c.add(1, 1);
                }
                break block3;
            }
            if (y2 >= y1) break block3;
            Calendar c = (Calendar)c2.clone();
            while (c.get(1) < y1) {
                yearDays -= c.getActualMaximum(2) + 1;
                c.add(1, 1);
            }
        }
        return yearDays + c2.get(2) - c1.get(2);
    }
}

