/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.svc.api;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.clazzes.svc.api.ServiceRegistry;

public abstract class ServiceProxyFactory {
    public static final <T> T getServiceProxy(ServiceRegistry registry, String key, Class<T> iface) {
        return (T)Proxy.newProxyInstance(iface.getClassLoader(), new Class[]{iface}, new ServiceInvocationHandler<T>(registry, key, iface));
    }

    public static final <T> T getServiceProxy(ServiceRegistry registry, Class<T> iface) {
        return (T)Proxy.newProxyInstance(iface.getClassLoader(), new Class[]{iface}, new AnyServiceInvocationHandler<T>(registry, iface));
    }

    private static final class ServiceInvocationHandler<T>
    implements InvocationHandler {
        private final ServiceRegistry registry;
        private final String key;
        private final Class<T> iface;

        private ServiceInvocationHandler(ServiceRegistry registry, String key, Class<T> iface) {
            this.registry = registry;
            this.key = key;
            this.iface = iface;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            T t = this.registry.getService(this.key, this.iface).get();
            try {
                return method.invoke(t, args);
            }
            catch (InvocationTargetException ite) {
                throw ite.getCause();
            }
        }

        public String toString() {
            return "ServiceProxy[" + this.key + "," + this.iface.getName() + "]";
        }
    }

    private static final class AnyServiceInvocationHandler<T>
    implements InvocationHandler {
        private final ServiceRegistry registry;
        private final Class<T> iface;

        private AnyServiceInvocationHandler(ServiceRegistry registry, Class<T> iface) {
            this.registry = registry;
            this.iface = iface;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            T t = this.registry.getAny(this.iface).get();
            try {
                return method.invoke(t, args);
            }
            catch (InvocationTargetException ite) {
                throw ite.getCause();
            }
        }

        public String toString() {
            return "AnyServiceProxy[" + this.iface.getName() + "]";
        }
    }
}

