#!/bin/sh
#
# $Id$
#
# License: Apache License, Version 2.0
#
#
# Startup script for jdbc2xml.
#
# Usage: jdbc2xml [--jdbc-drivers <jdbc-driver1>.jar[:<jdbc-driver2>.jar] <Main-options>.
#
# The loaded JDBC drivers may alternatively be contained in the
# CLASSPATH environment variable instead of specifying --jdbc-drivers 
#

if test "$JAVA_HOME" = ""
then
  JAVA_CMD=java
else
  JAVA_CMD=$JAVA_HOME/bin/java
fi

# This code is copied from maven's mvn startup script.
if [ -z "$JDBC2XML_HOME" ] ; then
  ## resolve links - $0 may be a link to jdbc2xml's home
  PRG="$0"

  # need this for relative symlinks
  while [ -h "$PRG" ] ; do
    ls=`ls -ld "$PRG"`
    link=`expr "$ls" : '.*-> \(.*\)$'`
    if expr "$link" : '/.*' > /dev/null; then
      PRG="$link"
    else
      PRG="`dirname "$PRG"`/$link"
    fi
  done

  saveddir=`pwd`

  JDBC2XML_HOME=`dirname "$PRG"`/..

  # make it fully qualified
  JDBC2XML_HOME=`cd "$JDBC2XML_HOME" && pwd`

  cd "$saveddir"
fi

LOGPROPS=
# The jdbc2xml command is guessed from the name of the symlink
COMMAND=`echo $0 | sed 's%.*/%%g'`
OPTIONLIST="$*"

DEBUG=0

# pull in JDBC drivers
while test $# -ge 1
do
    case "$1" in
    --debug)         LOGPROPS=-Dorg.slf4j.simpleLogger.log.org.clazzes.jdbc2xml=debug
        shift 1
        ;;
    --debug-startup) DEBUG=1
        shift 1
        ;;    
    --jdbc-drivers)  CLASSPATH="${CLASSPATH:+${CLASSPATH}:}$2"
        shift 2
        ;;
    --quiet)         LOGPROPS=-Dorg.slf4j.simpleLogger.log.org.clazzes.jdbc2xml=error
        shift 1
        ;;
    --verbose)       LOGPROPS=-Dorg.slf4j.simpleLogger.log.org.clazzes.jdbc2xml=trace
        shift 1
        ;;
    * )
        shift 1
        ;;
    esac
done

MODULEPATH="$JDBC2XML_HOME/lib/"

# add conf folder for simplelogger.properties
CLASSPATH="${CLASSPATH:+${CLASSPATH}:}$JDBC2XML_HOME/conf"

if test $DEBUG -ne 0
then
    echo '*****************************************************'
    echo $JAVA_CMD $LOGPROPS -cp $CLASSPATH -p $MODULEPATH -m org.clazzes.jdbc2xml $COMMAND $OPTIONLIST
    echo '*****************************************************'
fi

$JAVA_CMD $LOGPROPS -cp $CLASSPATH -p $MODULEPATH -m org.clazzes.jdbc2xml $COMMAND $OPTIONLIST
