/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.jdbc2xml.sql.impl;

import java.util.Locale;
import org.clazzes.jdbc2xml.sql.SqlIdentifierMapper;
import org.clazzes.jdbc2xml.sql.SqlIdentifierMapperFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlIdentifierMapperFactoryImpl
extends SqlIdentifierMapperFactory {
    private static final Logger log = LoggerFactory.getLogger(SqlIdentifierMapperFactoryImpl.class);

    @Override
    public SqlIdentifierMapper newMapper(String key) {
        if ("lower".equals(key)) {
            return new SqlIdentifierMapper(){

                @Override
                public String toExternal(String identifier) {
                    return identifier.toLowerCase(Locale.US);
                }
            };
        }
        if ("upper".equals(key)) {
            return new SqlIdentifierMapper(){

                @Override
                public String toExternal(String identifier) {
                    return identifier.toUpperCase(Locale.US);
                }
            };
        }
        if (key != null && !"id".equals(key)) {
            log.warn("Unsupported key [" + key + "], returning the id mapper.");
        }
        return new SqlIdentifierMapper(){

            @Override
            public String toExternal(String identifier) {
                return identifier;
            }
        };
    }
}

