/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.jdbc2xml.serialization.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.codec.BinaryEncoder;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.binary.Base64;
import org.clazzes.jdbc2xml.serialization.SerializationHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class BinarySerializationHandler
implements SerializationHandler {
    private byte[] value = null;
    private BinaryEncoder encoder = new Base64();

    @Override
    public void fetchData(ResultSet rs, int column) throws SQLException {
        this.value = rs.getBytes(column);
    }

    @Override
    public boolean isNull() {
        return this.value == null;
    }

    @Override
    public void pushData(ContentHandler handler) throws SAXException {
        byte[] enc;
        try {
            enc = this.encoder.encode(this.value);
        }
        catch (EncoderException e) {
            throw new SAXException("Error base64-encoding [" + this.value.length + "] bytes of binary data", (Exception)((Object)e));
        }
        char[] buf = new char[4096];
        int i = 0;
        while (i < enc.length) {
            int j = 0;
            while (j < buf.length && i < enc.length) {
                if (enc[i] != 13) {
                    buf[j++] = (char)enc[i];
                }
                ++i;
            }
            handler.characters(buf, 0, j);
        }
    }
}

