/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.jdbc2xml.schema.impl;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Properties;
import org.clazzes.jdbc2xml.helper.SQLHelper;
import org.clazzes.jdbc2xml.helper.TypesHelper;
import org.clazzes.jdbc2xml.schema.ColumnInfo;
import org.clazzes.jdbc2xml.schema.DataTypeNotSupportedException;
import org.clazzes.jdbc2xml.schema.ForeignKeyInfo;
import org.clazzes.jdbc2xml.schema.ISchemaEngine;
import org.clazzes.jdbc2xml.schema.IndexInfo;
import org.clazzes.jdbc2xml.schema.TableInfo;
import org.clazzes.jdbc2xml.schema.impl.AbstrDialectSupport;
import org.clazzes.jdbc2xml.schema.impl.ColumnHelper;
import org.clazzes.jdbc2xml.schema.impl.DDLHelper;
import org.clazzes.jdbc2xml.schema.impl.DropColumnCommand;
import org.clazzes.jdbc2xml.schema.impl.DropTableCommand;
import org.clazzes.jdbc2xml.sql.SqlCommand;
import org.clazzes.jdbc2xml.sql.SqlCommandQueue;
import org.clazzes.util.lang.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MSSQLServerDialect
extends AbstrDialectSupport {
    private static final Logger log = LoggerFactory.getLogger(MSSQLServerDialect.class);
    public static final String defaultDriverName = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    private static final String addColumnCommand = "ADD";
    private static final String renameTableCommand = "EXEC sp_rename '%s', '%s'";

    @Override
    public String getID() {
        return "MSSQLServer_9";
    }

    @Override
    public void pushCreateTable(ISchemaEngine schemaEngine, SqlCommandQueue queue, TableInfo ti) {
        queue.pushCommand(DDLHelper.buildCreateTable(ti, this, null), DDLHelper.buildDropTable(ti.getName()));
    }

    @Override
    public void pushRenameTable(ISchemaEngine schemaEngine, SqlCommandQueue queue, TableInfo ti, String newTableName) throws SQLException {
        queue.pushCommand(DDLHelper.buildRenameTable(renameTableCommand, ti.getName(), newTableName));
    }

    @Override
    public void pushDropTable(ISchemaEngine schemaEngine, SqlCommandQueue queue, TableInfo ti, boolean force) throws SQLException {
        if (force) {
            queue.pushCommand(DDLHelper.buildDropTable(ti.getName()), null);
        } else {
            queue.pushCommand(new DropTableCommand(schemaEngine, ti, this, null));
        }
    }

    private static StringBuffer appendColumnType(StringBuffer columnSpec, ColumnInfo columnInfo) {
        switch (columnInfo.getType()) {
            case -5: {
                columnSpec.append("BIGINT");
                break;
            }
            case -2: {
                if (columnInfo.getPrecision() == null) {
                    return null;
                }
                columnSpec.append("BINARY(" + String.valueOf(columnInfo.getPrecision()) + ")");
                break;
            }
            case -7: {
                columnSpec.append("BIT");
                break;
            }
            case 2004: {
                columnSpec.append("IMAGE");
                break;
            }
            case 16: {
                columnSpec.append("BIT");
                break;
            }
            case -15: 
            case 1: {
                if (columnInfo.getPrecision() == null) {
                    return null;
                }
                columnSpec.append("CHAR(" + String.valueOf(columnInfo.getPrecision()) + ")");
                break;
            }
            case 2005: {
                columnSpec.append("IMAGE");
                break;
            }
            case 91: {
                if (columnInfo.getPrecision() != null) {
                    columnSpec.append("DATETIME2(" + columnInfo.getPrecision() + ")");
                    break;
                }
                columnSpec.append("DATETIME");
                break;
            }
            case 3: {
                if (columnInfo.getPrecision() == null) {
                    columnSpec.append("DECIMAL");
                    break;
                }
                if (columnInfo.getScale() == null) {
                    columnSpec.append("DECIMAL(" + String.valueOf(columnInfo.getPrecision()) + ")");
                    break;
                }
                columnSpec.append("DECIMAL(" + String.valueOf(columnInfo.getPrecision()) + "," + String.valueOf(columnInfo.getScale()) + ")");
                break;
            }
            case 8: {
                columnSpec.append("FLOAT(53)");
                break;
            }
            case 6: {
                columnSpec.append("FLOAT(24)");
                break;
            }
            case 4: {
                columnSpec.append("INT");
                break;
            }
            case -4: {
                columnSpec.append("IMAGE");
                break;
            }
            case -16: 
            case -1: {
                columnSpec.append("NTEXT");
                break;
            }
            case 2: {
                if (columnInfo.getPrecision() == null) {
                    columnSpec.append("NUMERIC");
                    break;
                }
                if (columnInfo.getScale() == null) {
                    columnSpec.append("NUMERIC(" + String.valueOf(columnInfo.getPrecision()) + ")");
                    break;
                }
                columnSpec.append("NUMERIC(" + String.valueOf(columnInfo.getPrecision()) + "," + String.valueOf(columnInfo.getScale()) + ")");
                break;
            }
            case 7: {
                columnSpec.append("REAL");
                break;
            }
            case 5: {
                columnSpec.append("SMALLINT");
                break;
            }
            case 92: {
                columnSpec.append("DATETIME");
                break;
            }
            case 93: {
                columnSpec.append("DATETIME");
                break;
            }
            case 2014: {
                columnSpec.append("DATETIMEOFFSET");
                break;
            }
            case -6: {
                columnSpec.append("TINYINT");
                break;
            }
            case -3: {
                if (columnInfo.getPrecision() == null) {
                    columnSpec.append("VARBINARY(255)");
                    break;
                }
                columnSpec.append("VARBINARY(" + String.valueOf(columnInfo.getPrecision()) + ")");
                break;
            }
            case -9: 
            case 12: {
                if (columnInfo.getPrecision() == null) {
                    columnSpec.append("NVARCHAR(255)");
                    break;
                }
                columnSpec.append("NVARCHAR(" + String.valueOf(columnInfo.getPrecision()) + ")");
                break;
            }
            default: {
                throw new DataTypeNotSupportedException(columnInfo.getType());
            }
        }
        return columnSpec;
    }

    private void appendDefaultValue(StringBuffer columnSpec, ColumnInfo columnInfo, boolean query) {
        if (columnInfo.getDefaultValue() != null) {
            if (!query) {
                columnSpec.append(" default ");
            }
            if (TypesHelper.isNumeric(columnInfo.getType())) {
                columnSpec.append(columnInfo.getDefaultValue());
            } else {
                columnSpec.append('\'');
                this.quoteString(columnSpec, columnInfo.getDefaultValue());
                columnSpec.append('\'');
            }
        }
    }

    @Override
    public String createColumnSpec(ColumnInfo columnInfo) {
        StringBuffer columnSpec = new StringBuffer();
        columnSpec.append(columnInfo.getName());
        columnSpec.append(" ");
        if (MSSQLServerDialect.appendColumnType(columnSpec, columnInfo) == null) {
            return null;
        }
        this.appendDefaultValue(columnSpec, columnInfo, false);
        if (!columnInfo.isNullable()) {
            columnSpec.append(" NOT NULL");
        }
        if (columnInfo.isAutoIncrement()) {
            columnSpec.append(" IDENTITY NOT FOR REPLICATION");
        }
        return columnSpec.toString();
    }

    @Override
    public String defaultDriverName() {
        return defaultDriverName;
    }

    @Override
    public void quoteString(StringBuffer sb, String s) {
        SQLHelper.quoteISOSqlString(sb, s);
    }

    @Override
    public String normalizeDefaultValue(int type, String s) {
        if (s == null) {
            return null;
        }
        if (TypesHelper.isNumeric(type)) {
            if (s.startsWith("((") && s.endsWith("))")) {
                return s.substring(2, s.length() - 2);
            }
        } else if (s.startsWith("('") && s.endsWith("')")) {
            return s.substring(2, s.length() - 2).replace("''", "'");
        }
        return s;
    }

    private static String buildDropForeignKey(TableInfo ti, ForeignKeyInfo fki) {
        return DDLHelper.buildDropForeignKey(ti.getName(), fki.getName(), "DROP CONSTRAINT");
    }

    @Override
    public void pushAddForeignKey(SqlCommandQueue queue, TableInfo ti, ForeignKeyInfo fki) throws SQLException {
        queue.pushCommand(DDLHelper.buildAddForeignKey(ti.getName(), fki, false), MSSQLServerDialect.buildDropForeignKey(ti, fki));
    }

    @Override
    public void pushDropForeignKey(SqlCommandQueue queue, TableInfo ti, ForeignKeyInfo fki) throws SQLException {
        queue.pushCommand(MSSQLServerDialect.buildDropForeignKey(ti, fki), DDLHelper.buildAddForeignKey(ti.getName(), fki, false));
    }

    private static String buildAddIndex(TableInfo ti, IndexInfo indexInfo) throws SQLException {
        String baseAddIndex = DDLHelper.buildAddIndex(ti, indexInfo, true, true);
        StringBuilder sb = new StringBuilder();
        sb.append(baseAddIndex);
        boolean first = !baseAddIndex.contains(" WHERE ");
        for (String columnName : indexInfo.getColumns()) {
            ColumnInfo column = ti.getColumnInfo(columnName);
            if (!column.isNullable()) continue;
            if (first) {
                first = false;
                sb.append(" WHERE ");
            } else {
                sb.append(" AND ");
            }
            sb.append(columnName);
            sb.append(" IS NOT NULL ");
        }
        return sb.toString();
    }

    private static String buildDropIndex(TableInfo ti, IndexInfo indexInfo) throws SQLException {
        return DDLHelper.buildDropIndex(ti.getName(), indexInfo.getName(), true);
    }

    @Override
    public void pushAddIndex(SqlCommandQueue queue, TableInfo ti, IndexInfo indexInfo) throws SQLException {
        queue.pushCommand(MSSQLServerDialect.buildAddIndex(ti, indexInfo), MSSQLServerDialect.buildDropIndex(ti, indexInfo));
    }

    @Override
    public void pushDropIndex(SqlCommandQueue queue, TableInfo ti, IndexInfo indexInfo) throws SQLException {
        queue.pushCommand(MSSQLServerDialect.buildDropIndex(ti, indexInfo), MSSQLServerDialect.buildAddIndex(ti, indexInfo));
    }

    private String buildAddColumn(TableInfo ti, ColumnInfo ci) {
        return DDLHelper.buildAddColumn(ti.getName(), ci, this, addColumnCommand, false);
    }

    @Override
    public void pushAddColumn(SqlCommandQueue queue, TableInfo ti, ColumnInfo ci) throws SQLException {
        if (ci.getDefaultValue() == null) {
            queue.pushCommand(this.buildAddColumn(ti, ci), DDLHelper.buildDropColumn(ti.getName(), ci.getName()));
        } else {
            ColumnInfo ciNull = ColumnHelper.adaptNullability(ci, true);
            ColumnInfo ciNoDefNull = ColumnHelper.adaptDefault(ciNull, null);
            queue.pushCommand(this.buildAddColumn(ti, ciNoDefNull), DDLHelper.buildDropColumn(ti.getName(), ci.getName()));
            queue.pushCommand(new ModifyDefaultValueCommand(ti.getName(), ciNull, false, this));
            StringBuffer sql = new StringBuffer();
            sql.append("UPDATE ");
            sql.append(ti.getName());
            sql.append(" SET ");
            sql.append(ci.getName());
            sql.append(" = ");
            this.appendDefaultValue(sql, ci, true);
            StringBuffer rsql = new StringBuffer();
            rsql.append("UPDATE ");
            rsql.append(ti.getName());
            rsql.append(" SET ");
            rsql.append(ci.getName());
            rsql.append(" = NULL");
            queue.pushCommand(sql.toString(), rsql.toString());
            if (!ci.isNullable()) {
                queue.pushCommand(MSSQLServerDialect.buildAlterColumn(ti.getName(), ci), MSSQLServerDialect.buildAlterColumn(ti.getName(), ciNull));
            }
        }
    }

    @Override
    public void pushDropColumn(ISchemaEngine schemaEngine, SqlCommandQueue queue, TableInfo ti, ColumnInfo ci, boolean force) throws SQLException {
        if (ci.getDefaultValue() != null) {
            queue.pushCommand(new ModifyDefaultValueCommand(ti.getName(), ci, true, this));
        }
        ColumnInfo ciNoDef = ColumnHelper.adaptDefault(ci, null);
        if (force) {
            queue.pushCommand(DDLHelper.buildDropColumn(ti.getName(), ci.getName()), this.buildAddColumn(ti, ciNoDef));
        } else if (!ci.isNullable()) {
            ColumnInfo ciNull = ColumnHelper.adaptNullability(ciNoDef, true);
            MSSQLServerDialect.pushModifyColumnType(queue, ti, ciNoDef, ciNull);
            queue.pushCommand(new DropColumnCommand(schemaEngine, ti, ciNull, this, null, addColumnCommand, false));
        } else {
            queue.pushCommand(new DropColumnCommand(schemaEngine, ti, ciNoDef, this, null, addColumnCommand, false));
        }
    }

    private static String buildAlterColumn(String tableName, ColumnInfo columnInfo) throws SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("ALTER TABLE ");
        sql.append(tableName);
        sql.append(' ');
        sql.append("ALTER COLUMN ");
        sql.append(columnInfo.getName());
        sql.append(' ');
        if (MSSQLServerDialect.appendColumnType(sql, columnInfo) == null) {
            throw new SQLException("Cannot modify column [" + columnInfo.getName() + "] to type [" + TypesHelper.typeToString(columnInfo.getType()) + "]: Type is not supported.");
        }
        if (columnInfo.isNullable()) {
            sql.append(" NULL");
        } else {
            sql.append(" NOT NULL");
        }
        return sql.toString();
    }

    private static void pushModifyColumnType(SqlCommandQueue queue, TableInfo ti, ColumnInfo oldColumnInfo, ColumnInfo newColumnInfo) throws SQLException {
        if (Util.equalsNullAware((Object)oldColumnInfo.getPrecision(), (Object)newColumnInfo.getPrecision()) && Util.equalsNullAware((Object)oldColumnInfo.getScale(), (Object)newColumnInfo.getScale()) && oldColumnInfo.getType() == newColumnInfo.getType() && oldColumnInfo.isNullable() == newColumnInfo.isNullable()) {
            return;
        }
        queue.pushCommand(MSSQLServerDialect.buildAlterColumn(ti.getName(), newColumnInfo), MSSQLServerDialect.buildAlterColumn(ti.getName(), oldColumnInfo));
    }

    @Override
    public void pushChangeColumn(ISchemaEngine schemaEngine, SqlCommandQueue queue, TableInfo ti, ColumnInfo oldColumnInfo, ColumnInfo newColumnInfo) throws SQLException {
        ColumnInfo tmpInfo = ColumnHelper.adaptNullability(newColumnInfo, true);
        this.pushAddColumn(queue, ti, tmpInfo);
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE ");
        sql.append(ti.getName());
        sql.append(" SET ");
        sql.append(newColumnInfo.getName());
        sql.append(" = ");
        sql.append(oldColumnInfo.getName());
        StringBuffer rsql = new StringBuffer();
        rsql.append("UPDATE ");
        rsql.append(ti.getName());
        rsql.append(" SET ");
        rsql.append(newColumnInfo.getName());
        rsql.append(" = NULL");
        queue.pushCommand(sql.toString(), rsql.toString());
        sql.delete(0, sql.length());
        rsql.delete(0, rsql.length());
        if (!newColumnInfo.isNullable()) {
            MSSQLServerDialect.pushModifyColumnType(queue, ti, tmpInfo, newColumnInfo);
        }
        this.pushDropColumn(schemaEngine, queue, ti, oldColumnInfo, true);
    }

    @Override
    public void pushModifyColumn(ISchemaEngine schemaEngine, SqlCommandQueue queue, TableInfo ti, ColumnInfo oldColumnInfo, ColumnInfo newColumnInfo) throws SQLException {
        if (oldColumnInfo.getDefaultValue() != null) {
            queue.pushCommand(new ModifyDefaultValueCommand(ti.getName(), oldColumnInfo, true, this));
        }
        MSSQLServerDialect.pushModifyColumnType(queue, ti, oldColumnInfo, newColumnInfo);
        if (newColumnInfo.getDefaultValue() != null) {
            queue.pushCommand(new ModifyDefaultValueCommand(ti.getName(), newColumnInfo, false, this));
        }
    }

    @Override
    public String constructJDBCURL(String hostname, Integer port, String databaseName, Properties properties) {
        StringBuffer url = new StringBuffer("jdbc:sqlserver://");
        if (hostname != null && hostname.length() > 0) {
            url.append(hostname);
        } else {
            url.append("localhost");
        }
        url.append(':');
        if (port != null && port > 0) {
            url.append(port);
        } else {
            url.append("1433");
        }
        url.append(';');
        if (databaseName != null && databaseName.length() > 0) {
            url.append("databaseName=");
            url.append(databaseName);
            url.append(';');
        }
        if (properties != null && properties.size() > 0) {
            Enumeration<?> propertyNames = properties.propertyNames();
            while (propertyNames.hasMoreElements()) {
                String propertyName = propertyNames.toString();
                String propertyValue = properties.getProperty(propertyName);
                url.append(propertyName);
                url.append('=');
                url.append(propertyValue);
                url.append(';');
            }
        }
        return url.toString();
    }

    @Override
    public int getMappedSqlType(String dialectDataType) {
        switch (dialectDataType = dialectDataType.toUpperCase().replace(" ", "_").trim()) {
            case "DATETIMEOFFSET": {
                return 2014;
            }
            case "DATETIME": {
                return 93;
            }
        }
        throw new DataTypeNotSupportedException(dialectDataType);
    }

    @Override
    public void fetchAdditionalColumnInfo(ISchemaEngine schemaEngine, TableInfo ti, ColumnInfo ci) {
    }

    private static class ModifyDefaultValueCommand
    implements SqlCommand {
        private String table;
        private String column;
        private String performSql;
        private String rollbackSql;

        private void dropDefaultValue(Connection connection) throws SQLException {
            if (this.table == null || this.column == null) {
                throw new SQLException("This statement has already been committed.");
            }
            Statement statement = connection.createStatement();
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT dl.name FROM sys.tables AS tl,sys.columns AS cl,sys.default_constraints AS dl WHERE tl.name = '");
            sql.append(this.table);
            sql.append("' AND cl.object_id = tl.object_id AND cl.name = '");
            sql.append(this.column);
            sql.append("' AND dl.parent_object_id = tl.object_id AND dl.parent_column_id = cl.column_id");
            ResultSet rs = statement.executeQuery(sql.toString());
            if (!rs.next()) {
                throw new SQLException("Default value constraint for column [" + this.column + "] on table [" + this.table + "] could not be found.");
            }
            sql.delete(0, sql.length());
            sql.append("ALTER TABLE ");
            sql.append(this.table);
            sql.append(" DROP CONSTRAINT ");
            sql.append(rs.getString(1));
            rs.close();
            if (log.isDebugEnabled()) {
                log.debug("Executing drop default value statement [" + String.valueOf(sql) + "].");
            }
            statement.executeUpdate(sql.toString());
            statement.close();
        }

        public ModifyDefaultValueCommand(String table, ColumnInfo column, boolean drop, MSSQLServerDialect dialect) {
            this.table = table;
            this.column = column.getName();
            StringBuffer sql = new StringBuffer();
            sql.append("ALTER TABLE ");
            sql.append(table);
            sql.append(" ADD CONSTRAINT DF__");
            sql.append(table);
            sql.append("__");
            sql.append(column.getName());
            sql.append("__");
            sql.append(DDLHelper.buildHexSuffix());
            dialect.appendDefaultValue(sql, column, false);
            sql.append(" FOR ");
            sql.append(column.getName());
            sql.append(" WITH VALUES");
            if (drop) {
                this.performSql = null;
                this.rollbackSql = sql.toString();
            } else {
                this.performSql = sql.toString();
                this.rollbackSql = null;
            }
        }

        @Override
        public void perform(Connection connection) throws SQLException {
            if (this.performSql != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Executing add default value statement [" + this.performSql + "].");
                }
                SQLHelper.executeUpdate(connection, this.performSql);
            } else {
                this.dropDefaultValue(connection);
            }
        }

        @Override
        public void rollback(Connection connection) throws SQLException {
            if (this.rollbackSql != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Executing add default value statement [" + this.rollbackSql + "] during rollback.");
                }
                SQLHelper.executeUpdate(connection, this.rollbackSql);
            } else {
                this.dropDefaultValue(connection);
            }
        }

        @Override
        public void cleanupOnCommit(Connection connection) throws SQLException {
            this.column = null;
            this.table = null;
            this.performSql = null;
            this.rollbackSql = null;
        }

        @Override
        public String getTempTableName() {
            return null;
        }

        @Override
        public boolean isTempTableCreated() {
            return false;
        }
    }
}

