/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.jdbc2xml.schema.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.clazzes.jdbc2xml.helper.JAVAHelper;
import org.clazzes.jdbc2xml.helper.SQLHelper;
import org.clazzes.jdbc2xml.schema.ColumnInfo;
import org.clazzes.jdbc2xml.schema.Dialect;
import org.clazzes.jdbc2xml.schema.ISchemaEngine;
import org.clazzes.jdbc2xml.schema.TableInfo;
import org.clazzes.jdbc2xml.schema.impl.DDLHelper;
import org.clazzes.jdbc2xml.schema.impl.NameHelper;
import org.clazzes.jdbc2xml.sql.SqlCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropColumnCommand
implements SqlCommand {
    private static final Logger log = LoggerFactory.getLogger(DropColumnCommand.class);
    private final String tableName;
    private final String columnName;
    private final String tempTableName;
    private final String createTempTable;
    private boolean tempTableCreated;
    private final String restoreOrignialColumn;
    private final String saveOriginalData;
    private final String selectBackupData;
    private final String restoreOriginalData;

    public DropColumnCommand(ISchemaEngine schemaEngine, TableInfo ti, ColumnInfo ci, Dialect dialect, String suffix, String addColumnCommand, boolean addStatementInBrackets) throws SQLException {
        if (ti.getPrimaryKey() == null) {
            throw new SQLException("Dropping of columns from table without primary key is not supported.");
        }
        this.tableName = ti.getName();
        this.columnName = ci.getName();
        this.tempTableName = NameHelper.buildTempTableName(schemaEngine, ti.getName(), ci.getName(), DDLHelper.buildHexSuffix());
        TableInfo tempTableInfo = new TableInfo(this.tempTableName);
        ArrayList<ColumnInfo> tempColumns = new ArrayList<ColumnInfo>(ti.getColumns().size());
        for (String pkColumn : ti.getPrimaryKey().getColumns()) {
            if (this.columnName.equals(pkColumn)) {
                throw new SQLException("Dropping of primary key column [" + pkColumn + "] is not supported.");
            }
            tempColumns.add(ti.getColumnInfo(pkColumn));
        }
        tempColumns.add(ci);
        tempTableInfo.setColumns(tempColumns);
        this.createTempTable = DDLHelper.buildCreateTable(tempTableInfo, dialect, suffix);
        this.restoreOrignialColumn = DDLHelper.buildAddColumn(this.tableName, ci, dialect, addColumnCommand, addStatementInBrackets);
        this.saveOriginalData = "INSERT INTO " + this.tempTableName + "(" + JAVAHelper.joinStrings(ti.getPrimaryKey().getColumns()) + "," + this.columnName + ") SELECT " + JAVAHelper.joinStrings(ti.getPrimaryKey().getColumns()) + "," + this.columnName + " FROM " + this.tableName;
        this.selectBackupData = "SELECT " + this.columnName + "," + JAVAHelper.joinStrings(ti.getPrimaryKey().getColumns()) + " FROM " + this.tempTableName;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE ");
        sql.append(this.tableName);
        sql.append(" SET ");
        sql.append(this.columnName);
        sql.append(" = ? WHERE ");
        boolean first = true;
        for (String pkColumn : ti.getPrimaryKey().getColumns()) {
            if (first) {
                first = false;
            } else {
                sql.append(" AND ");
            }
            sql.append(pkColumn);
            sql.append("=?");
        }
        this.restoreOriginalData = sql.toString();
    }

    @Override
    public void cleanupOnCommit(Connection connection) throws SQLException {
        if (this.tempTableCreated) {
            if (log.isDebugEnabled()) {
                log.debug("Dropping backup table [" + this.tempTableName + "] after commit.");
            }
            SQLHelper.executeUpdate(connection, DDLHelper.buildDropTable(this.tempTableName));
            this.tempTableCreated = false;
        }
    }

    @Override
    public void perform(Connection connection) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("Creating backup table [" + this.tempTableName + "] for future rollback operations.");
        }
        SQLHelper.executeUpdate(connection, this.createTempTable);
        this.tempTableCreated = true;
        try {
            if (log.isDebugEnabled()) {
                log.debug("Populating backup table [" + this.tempTableName + "] with data from table [" + this.tableName + "] for future rollback operations.");
            }
            SQLHelper.executeUpdate(connection, this.saveOriginalData);
            if (log.isDebugEnabled()) {
                log.debug("Dropping column [" + this.columnName + "] of table [" + this.tableName + "].");
            }
            SQLHelper.executeUpdate(connection, DDLHelper.buildDropColumn(this.tableName, this.columnName));
        }
        catch (SQLException e) {
            log.error("Error during drop of column [" + this.columnName + "] of table [" + this.tableName + "], dropping backup table [" + this.tempTableName + "].", (Throwable)e);
            SQLHelper.executeUpdate(connection, DDLHelper.buildDropTable(this.tempTableName));
            this.tempTableCreated = false;
            throw e;
        }
    }

    @Override
    public void rollback(Connection connection) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("Restoring column [" + this.columnName + "] of table [" + this.tableName + "] during rollback.");
        }
        SQLHelper.executeUpdate(connection, this.restoreOrignialColumn);
        if (log.isDebugEnabled()) {
            log.debug("Populating table [" + this.tableName + "] with data from backup table [" + this.tempTableName + "] during rollback.");
            log.debug("select sql [" + this.selectBackupData + "].");
            log.debug("populate sql [" + this.restoreOriginalData + "].");
        }
        Statement statement = connection.createStatement(1003, 1007);
        ResultSet rs = statement.executeQuery(this.selectBackupData);
        PreparedStatement update = connection.prepareStatement(this.restoreOriginalData);
        while (rs.next()) {
            for (int i = 1; i <= rs.getMetaData().getColumnCount(); ++i) {
                SQLHelper.copyResultField(update, i, rs, i);
            }
            update.execute();
        }
        update.close();
        statement.close();
        if (log.isDebugEnabled()) {
            log.debug("Dropping backup table [" + this.tempTableName + "] during rollback.");
        }
        SQLHelper.executeUpdate(connection, DDLHelper.buildDropTable(this.tempTableName));
        this.tempTableCreated = false;
    }

    @Override
    public String getTempTableName() {
        return this.tempTableName;
    }

    @Override
    public boolean isTempTableCreated() {
        return this.tempTableCreated;
    }
}

