/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.jdbc2xml.schema.impl;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.clazzes.jdbc2xml.schema.Dialect;
import org.clazzes.jdbc2xml.schema.DialectFactory;
import org.clazzes.jdbc2xml.schema.impl.DerbyDialect;
import org.clazzes.jdbc2xml.schema.impl.MSSQLServerDialect;
import org.clazzes.jdbc2xml.schema.impl.MariaDBDialect;
import org.clazzes.jdbc2xml.schema.impl.MySQLDialect;
import org.clazzes.jdbc2xml.schema.impl.OracleDialect;
import org.clazzes.jdbc2xml.schema.impl.PostgreSQLDialect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DialectFactoryImpl
extends DialectFactory {
    private static Logger log = LoggerFactory.getLogger(DialectFactoryImpl.class);

    @Override
    public Dialect newDialect(DatabaseMetaData databaseMetaData) throws SQLException {
        if (databaseMetaData.getDatabaseProductName().contains("MySQL")) {
            if (databaseMetaData.getDriverName().contains("MariaDB")) {
                return new MariaDBDialect();
            }
            return new MySQLDialect();
        }
        if (databaseMetaData.getDatabaseProductName().contains("MariaDB")) {
            MariaDBDialect r = new MariaDBDialect();
            r.setProperty("unquoteDefaultValues", "true");
            return r;
        }
        if (databaseMetaData.getDatabaseProductName().contains("Microsoft SQL Server")) {
            return new MSSQLServerDialect();
        }
        if (databaseMetaData.getDatabaseProductName().contains("Apache Derby")) {
            return new DerbyDialect();
        }
        if (databaseMetaData.getDatabaseProductName().contains("Oracle")) {
            return new OracleDialect();
        }
        if (databaseMetaData.getDatabaseProductName().contains("PostgreSQL")) {
            return new PostgreSQLDialect();
        }
        log.error("newDialect(databaseMetaData): Could not determine dialect for database Product [" + databaseMetaData.getDatabaseProductName() + "].");
        return null;
    }

    @Override
    public Dialect newDialect(String databaseURL) throws SQLException {
        if (databaseURL.startsWith("jdbc:mysql")) {
            return new MySQLDialect();
        }
        if (databaseURL.startsWith("jdbc:mariadb")) {
            return new MariaDBDialect();
        }
        if (databaseURL.startsWith("jdbc:sqlserver")) {
            return new MSSQLServerDialect();
        }
        if (databaseURL.startsWith("jdbc:derby")) {
            return new DerbyDialect();
        }
        if (databaseURL.startsWith("jdbc:oracle")) {
            return new OracleDialect();
        }
        if (databaseURL.startsWith("jdbc:postgresql")) {
            return new PostgreSQLDialect();
        }
        log.error("newDialect(databaseURL): Could not determine dialect for database URL [" + databaseURL + "].");
        return null;
    }
}

