/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.jdbc2xml.schema;

import java.util.ArrayList;
import java.util.List;
import org.clazzes.jdbc2xml.schema.ColumnInfo;
import org.clazzes.jdbc2xml.schema.ForeignKeyInfo;
import org.clazzes.jdbc2xml.schema.IndexInfo;
import org.clazzes.jdbc2xml.schema.PrimaryKeyInfo;

public class TableInfo {
    private String name;
    private String comment;
    private List<ColumnInfo> columns;
    private PrimaryKeyInfo primaryKey;
    private List<ForeignKeyInfo> foreignKeys;
    private List<IndexInfo> indices;

    public TableInfo() {
    }

    public TableInfo(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public List<ColumnInfo> getColumns() {
        return this.columns;
    }

    public void setColumns(List<ColumnInfo> columns) {
        this.columns = columns;
    }

    public void addColumn(ColumnInfo ci) {
        if (this.columns == null) {
            this.columns = new ArrayList<ColumnInfo>();
        }
        this.columns.add(ci);
    }

    public ColumnInfo getColumnInfo(String columnName) {
        if (this.columns == null || columnName == null) {
            return null;
        }
        for (ColumnInfo ci : this.columns) {
            if (!ci.getName().equalsIgnoreCase(columnName)) continue;
            return ci;
        }
        return null;
    }

    public void replaceColumnInfo(String columnName, ColumnInfo newColumnInfo) {
        if (this.columns == null || columnName == null || newColumnInfo == null) {
            return;
        }
        for (int i = 0; i < this.columns.size(); ++i) {
            ColumnInfo ci = this.columns.get(i);
            if (!ci.getName().equalsIgnoreCase(columnName)) continue;
            this.columns.set(i, newColumnInfo);
            return;
        }
    }

    public void removeColumnInfo(String columnName) {
        if (this.columns == null || columnName == null) {
            return;
        }
        int index = -1;
        for (int i = 0; i < this.columns.size(); ++i) {
            ColumnInfo ci = this.columns.get(i);
            if (!ci.getName().equalsIgnoreCase(columnName)) continue;
            index = i;
            break;
        }
        if (index >= 0) {
            this.columns.remove(index);
        }
    }

    public void removeIndex(String indexName) {
        if (this.indices == null || indexName == null) {
            return;
        }
        int indexOffset = -1;
        for (int i = 0; i < this.indices.size(); ++i) {
            IndexInfo ii = this.indices.get(i);
            if (!indexName.equalsIgnoreCase(ii.getName())) continue;
            indexOffset = i;
            break;
        }
        if (indexOffset >= 0) {
            this.indices.remove(indexOffset);
        }
    }

    public PrimaryKeyInfo getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(PrimaryKeyInfo primaryKey) {
        this.primaryKey = primaryKey;
    }

    public List<ForeignKeyInfo> getForeignKeys() {
        return this.foreignKeys;
    }

    public void setForeignKeys(List<ForeignKeyInfo> foreignKeys) {
        this.foreignKeys = foreignKeys;
    }

    public void addForeignKey(ForeignKeyInfo fki) {
        if (this.foreignKeys == null) {
            this.foreignKeys = new ArrayList<ForeignKeyInfo>();
        }
        this.foreignKeys.add(fki);
    }

    public ForeignKeyInfo getForeignKeyInfo(String fkName) {
        if (this.foreignKeys == null || fkName == null) {
            return null;
        }
        for (ForeignKeyInfo fki : this.foreignKeys) {
            if (fki == null || !fkName.equalsIgnoreCase(fki.getName())) continue;
            return fki;
        }
        return null;
    }

    public IndexInfo getIndexInfo(String idxName) {
        if (this.indices == null || idxName == null) {
            return null;
        }
        for (IndexInfo idxInfo : this.indices) {
            if (idxInfo == null || !idxName.equalsIgnoreCase(idxInfo.getName())) continue;
            return idxInfo;
        }
        return null;
    }

    public void removeForeignKey(String fkName) {
        if (this.foreignKeys == null || fkName == null) {
            return;
        }
        int index = -1;
        for (int i = 0; i < this.foreignKeys.size(); ++i) {
            if (!fkName.equalsIgnoreCase(this.foreignKeys.get(i).getName())) continue;
            index = i;
            break;
        }
        if (index >= 0) {
            this.foreignKeys.remove(index);
        }
    }

    public List<IndexInfo> getIndices() {
        return this.indices;
    }

    public void setIndices(List<IndexInfo> indices) {
        this.indices = indices;
    }

    public void addIndex(IndexInfo indexInfo) {
        if (this.indices == null) {
            this.indices = new ArrayList<IndexInfo>();
        }
        this.indices.add(indexInfo);
    }

    public void addIndex(String indexName, String indexColumns, boolean unique, String filterCondition) {
        IndexInfo indexInfo = new IndexInfo(indexName, indexColumns, unique, filterCondition);
        this.addIndex(indexInfo);
    }

    public boolean indexContainsNullableColumns(IndexInfo indexInfo) {
        if (indexInfo != null && indexInfo.getColumns() != null && indexInfo.getColumns().size() > 0) {
            for (String colName : indexInfo.getColumns()) {
                ColumnInfo colInfo = this.getColumnInfo(colName);
                if (!colInfo.isNullable()) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "TableInfo{name='" + this.name + "', comment='" + this.comment + "'}";
    }
}

