/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.jdbc2xml.schema;

import java.util.ArrayList;
import java.util.List;
import org.clazzes.jdbc2xml.helper.JAVAHelper;
import org.clazzes.jdbc2xml.helper.SQLHelper;
import org.clazzes.jdbc2xml.sql.SqlIdentifierMapper;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class PrimaryKeyInfo {
    private String name;
    private List<String> columns;

    public PrimaryKeyInfo() {
    }

    public PrimaryKeyInfo(String name, String columns) {
        this.name = name;
        this.columns = JAVAHelper.splitString(columns);
    }

    public PrimaryKeyInfo(Attributes atts) {
        String col_s;
        this.name = atts.getValue("name");
        if ("PRIMARY".equalsIgnoreCase(this.name)) {
            this.name = "";
        }
        this.columns = (col_s = atts.getValue("columns")) == null ? null : JAVAHelper.splitString(col_s);
    }

    public Attributes toAttributes(SqlIdentifierMapper mapper) {
        AttributesImpl atts = new AttributesImpl();
        if (this.name != null) {
            atts.addAttribute("", "", "name", "CDATA", mapper.toExternal(this.name));
        }
        if (this.columns != null) {
            atts.addAttribute("", "", "columns", "CDATA", SQLHelper.joinIdentifiers(this.columns, mapper));
        }
        return atts;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public void setColumns(List<String> columns) {
        this.columns = columns;
    }

    public void addColumn(String column) {
        if (this.columns == null) {
            this.columns = new ArrayList<String>();
        }
        this.columns.add(column);
    }

    public String toString() {
        return "PrimaryKeyInfo{name='" + this.name + "', columns=" + String.valueOf(this.columns) + "}";
    }
}

