/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.jdbc2xml.sax.impl;

import java.io.File;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class ZipEntryResolver
implements EntityResolver {
    private static final Logger log = LoggerFactory.getLogger(ZipEntryResolver.class);
    private final ZipFile zipFile;

    public ZipEntryResolver(ZipFile zipFile) {
        this.zipFile = zipFile;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) {
        String part;
        int pos;
        if (log.isDebugEnabled()) {
            log.debug("resolveEntity: publicId=[" + publicId + "], systemId=[" + systemId + "]");
        }
        if ((pos = (part = systemId).lastIndexOf(File.separatorChar)) >= 0) {
            part = part.substring(pos + 1);
        }
        ZipEntry zipEntry = this.zipFile.getEntry(part);
        try {
            InputSource isrc = new InputSource(this.zipFile.getInputStream(zipEntry));
            isrc.setPublicId(publicId);
            isrc.setSystemId(systemId);
            return isrc;
        }
        catch (IOException e) {
            log.error("Error resolving ZipEntry [" + systemId + "].");
            return null;
        }
    }
}

