/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.jdbc2xml.sax.impl;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.TimeZone;
import org.clazzes.jdbc2xml.deserialization.DeserializationHandler;
import org.clazzes.jdbc2xml.deserialization.DeserializationHandlerFactory;
import org.clazzes.jdbc2xml.deserialization.IDeserializationHandlerFactory;
import org.clazzes.jdbc2xml.schema.ColumnInfo;
import org.clazzes.util.xml.SAXTagHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ValueTagHandler
implements SAXTagHandler {
    private static final IDeserializationHandlerFactory deserializationHandlerFactory = DeserializationHandlerFactory.newInstance();
    private PreparedStatement insert;
    private DeserializationHandler deserializationHandler;
    private int column;
    private boolean tagStarted;

    public ValueTagHandler(ColumnInfo ci, TimeZone timeZone, PreparedStatement insert, int column) throws SAXException {
        this.deserializationHandler = deserializationHandlerFactory.newDeserializationHandler(ci, timeZone);
        this.insert = insert;
        this.column = column;
        this.tagStarted = false;
    }

    public void startTag() throws SAXException {
        this.deserializationHandler.startCharacters();
        this.tagStarted = true;
    }

    public void finishTag() throws SAXException {
        if (this.tagStarted) {
            this.tagStarted = false;
        } else {
            try {
                this.deserializationHandler.fillColumn(this.insert, this.column);
            }
            catch (SQLException e) {
                throw new SAXException("SQL error setting null value to column [" + this.column + "].", e);
            }
        }
    }

    public void closeTag(String uri, String localName, String name) throws SAXException {
        try {
            this.deserializationHandler.fillColumn(this.insert, this.column);
        }
        catch (SQLException e) {
            throw new SAXException("SQL error setting value to column [" + this.column + "].", e);
        }
    }

    public void processCharacters(char[] ch, int start, int length) throws SAXException {
        this.deserializationHandler.addCharacters(ch, start, length);
    }

    public SAXTagHandler startChildElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        throw new SAXException("value does not accept child elements.");
    }
}

