/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.jdbc2xml.sax;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.TimeZone;
import org.clazzes.jdbc2xml.Constants;
import org.clazzes.jdbc2xml.sax.impl.InsertContext;
import org.clazzes.jdbc2xml.sax.impl.XmlDumpTagHandler;
import org.clazzes.jdbc2xml.schema.ISchemaEngine;
import org.clazzes.jdbc2xml.schema.SchemaEngine;
import org.clazzes.jdbc2xml.tools.ProcessRestrictionFilter;
import org.clazzes.util.xml.SAXTagHandler;
import org.clazzes.util.xml.SimpleContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class InsertContentHandler
extends SimpleContentHandler {
    private InsertContext context;

    public InsertContentHandler(Connection connection, TimeZone timeZone) throws SQLException {
        ISchemaEngine schemaEngine = SchemaEngine.newInstance();
        schemaEngine.setConnection(connection);
        schemaEngine.setTimeZone(timeZone);
        this.context = new InsertContext(schemaEngine);
    }

    public InsertContentHandler(ISchemaEngine schemaEngine) throws SQLException {
        this.context = new InsertContext(schemaEngine);
    }

    public ProcessRestrictionFilter getProcessRestrictionFilter() {
        return this.context.getProcessRestrictionFilter();
    }

    public void setProcessRestrictionFilter(ProcessRestrictionFilter processFilter) {
        this.context.setProcessRestrictionFilter(processFilter);
        this.context.getSchemaEngine().getDialect().setProperties(processFilter.getDialectProps());
    }

    protected SAXTagHandler getRootHandler(String uri, String localName, String name, Attributes atts) throws SAXException {
        if (!Constants.JDBC2XML_NS_URI.equals(uri)) {
            throw new SAXException("Namspace URI [" + uri + "] is not supported.");
        }
        if (!Constants.TOP_TAG_NAME.equals(localName)) {
            throw new SAXException("Top level element [" + localName + "] is not supported.");
        }
        if (this.context.getProcessRestrictionFilter() == null) {
            this.context.setProcessRestrictionFilter(new ProcessRestrictionFilter());
        }
        return new XmlDumpTagHandler(this.context);
    }
}

