/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.jdbc2xml.helper;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;

public abstract class StreamHelper {
    public static InputStream makeInputStream(String filename) throws IOException {
        if (filename == null) {
            return System.in;
        }
        InputStream is = new FileInputStream(filename);
        if (filename.endsWith(".gz")) {
            is = new GZIPInputStream(is);
        } else if (filename.endsWith(".bz2")) {
            is = new BZip2CompressorInputStream(is);
        }
        return is;
    }

    public static OutputStream makeOutpuStream(String filename, Integer compression) throws IOException {
        if (filename == null) {
            return System.out;
        }
        OutputStream os = new FileOutputStream(filename);
        if (filename.endsWith(".gz")) {
            os = new GZIPOutputStream(os);
        } else if (filename.endsWith(".bz2")) {
            os = compression == null ? new BZip2CompressorOutputStream(os) : new BZip2CompressorOutputStream(os, compression.intValue());
        } else if (filename.endsWith(".zip")) {
            os = new ZipOutputStream(os);
            ((ZipOutputStream)os).setLevel(9);
        }
        return os;
    }
}

