/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.jdbc2xml.deserialization.impl;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Calendar;
import java.util.TimeZone;
import org.clazzes.jdbc2xml.deserialization.impl.AbstractSbDeserializationHandler;
import org.clazzes.util.datetime.ISO8601Format;

public class TimestampDeserializationHandler
extends AbstractSbDeserializationHandler {
    private ISO8601Format df;

    public TimestampDeserializationHandler(TimeZone timeZone, int type) {
        super(type);
        this.df = new ISO8601Format(ISO8601Format.MILLISECOND_FORMAT_NO_TZ, timeZone);
    }

    @Override
    protected void fillColumnValue(PreparedStatement ps, int column, String value) throws SQLException {
        if (value == null) {
            ps.setNull(column, this.type);
        } else {
            try {
                Calendar c = (Calendar)this.df.parseObject(value);
                ps.setTimestamp(column, new Timestamp(c.getTimeInMillis()), c);
            }
            catch (ParseException e) {
                throw new SQLException("XML value [" + value + "] is not a valid ISO8601 string.");
            }
        }
    }
}

