/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.jdbc2xml.deserialization.impl;

import java.util.TimeZone;
import org.clazzes.jdbc2xml.deserialization.DeserializationHandler;
import org.clazzes.jdbc2xml.deserialization.DeserializationHandlerFactory;
import org.clazzes.jdbc2xml.deserialization.impl.BigDecimalDeserializationHandler;
import org.clazzes.jdbc2xml.deserialization.impl.BinaryDeserializationHandler;
import org.clazzes.jdbc2xml.deserialization.impl.BooleanDeserializationHandler;
import org.clazzes.jdbc2xml.deserialization.impl.DateDeserializationHandler;
import org.clazzes.jdbc2xml.deserialization.impl.DoubleDeserializationHandler;
import org.clazzes.jdbc2xml.deserialization.impl.FloatDeserializationHandler;
import org.clazzes.jdbc2xml.deserialization.impl.IntegerDeserializationHandler;
import org.clazzes.jdbc2xml.deserialization.impl.StringDeserializationHandler;
import org.clazzes.jdbc2xml.deserialization.impl.TimestampDeserializationHandler;
import org.clazzes.jdbc2xml.schema.ColumnInfo;

public class DeserializationHandlerFactoryImpl
extends DeserializationHandlerFactory {
    @Override
    public DeserializationHandler newDeserializationHandler(ColumnInfo ci, TimeZone timeZone) {
        switch (ci.getType()) {
            case -6: 
            case 4: 
            case 5: {
                return new IntegerDeserializationHandler(ci.getType());
            }
            case 2: {
                if ((ci.getScale() == null || ci.getScale() == 0) && ci.getPrecision() != null && ci.getPrecision() <= 18) {
                    return new IntegerDeserializationHandler(ci.getType());
                }
                return new BigDecimalDeserializationHandler(ci.getType());
            }
            case 6: {
                return new FloatDeserializationHandler(ci.getType());
            }
            case 8: {
                return new DoubleDeserializationHandler(ci.getType());
            }
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                return new StringDeserializationHandler(ci.getType());
            }
            case -5: 
            case 3: 
            case 7: {
                return new BigDecimalDeserializationHandler(ci.getType());
            }
            case 91: {
                return new DateDeserializationHandler(timeZone, ci.getType());
            }
            case 93: 
            case 2014: {
                return new TimestampDeserializationHandler(timeZone, ci.getType());
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return new BinaryDeserializationHandler(ci.getType());
            }
            case -7: 
            case 16: {
                return new BooleanDeserializationHandler(ci.getType());
            }
        }
        return null;
    }
}

