/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.svc.api.monitoring;

import java.util.Objects;
import org.clazzes.svc.api.monitoring.HealthStatus;

public class HealthInfo
implements Comparable<HealthInfo> {
    private final HealthStatus status;
    private final String explanation;

    public HealthInfo(HealthStatus status) {
        this.status = Objects.requireNonNull(status);
        this.explanation = null;
    }

    public HealthInfo(HealthStatus status, String explanation) {
        this.status = Objects.requireNonNull(status);
        this.explanation = explanation;
    }

    public static HealthInfo ofValue(double v) {
        return new HealthInfo(HealthStatus.ofValue(v));
    }

    public static HealthInfo ofValue(double v, String explanation) {
        return new HealthInfo(HealthStatus.ofValue(v), explanation);
    }

    public HealthStatus getStatus() {
        return this.status;
    }

    public String getExplanation() {
        return this.explanation;
    }

    @Override
    public int compareTo(HealthInfo o) {
        return this.status.compareTo(o.status);
    }

    public String toString() {
        return "HealthInfo [status=" + String.valueOf((Object)this.status) + ", explanation=" + this.explanation + "]";
    }
}

