/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.svc.api;

import java.io.Serializable;
import java.lang.module.ModuleDescriptor;
import java.net.URI;
import java.util.Optional;

public class ModuleInfo
implements Serializable,
Comparable<ModuleInfo> {
    private static final long serialVersionUID = -2011953965659972023L;
    private final String layer;
    private final String name;
    private final Optional<ModuleDescriptor.Version> version;
    private final Optional<URI> location;

    public ModuleInfo(String layer, String name, Optional<ModuleDescriptor.Version> version, Optional<URI> location) {
        this.layer = layer;
        this.name = name;
        this.version = version;
        this.location = location;
    }

    public String getLayer() {
        return this.layer;
    }

    public String getName() {
        return this.name;
    }

    public Optional<ModuleDescriptor.Version> getVersion() {
        return this.version;
    }

    public Optional<URI> getLocation() {
        return this.location;
    }

    @Override
    public int compareTo(ModuleInfo o) {
        String lo = o.getLayer();
        if (this.layer == null) {
            return lo == null ? 0 : -1;
        }
        if (lo == null) {
            return 1;
        }
        int ret = this.layer.compareTo(lo);
        if (ret != 0) {
            return ret;
        }
        String no = o.getName();
        if (this.name == null) {
            return no == null ? 0 : -1;
        }
        if (no == null) {
            return 1;
        }
        ret = this.name.compareTo(no);
        if (ret != 0) {
            return ret;
        }
        Optional<ModuleDescriptor.Version> vo = o.getVersion();
        if (this.version.isEmpty()) {
            return vo.isEmpty() ? 0 : -1;
        }
        if (vo.isEmpty()) {
            return 1;
        }
        return this.version.get().compareTo(vo.get());
    }
}

