/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.htpasswd.jaas;

import java.io.IOException;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.clazzes.login.htpasswd.jaas.HtpasswdAuthServiceFactory;
import org.clazzes.login.htpasswd.jaas.HtpasswdGroup;
import org.clazzes.login.htpasswd.jaas.HtpasswdPrincipal;
import org.clazzes.login.htpasswd.jaas.IHtpasswdAuthService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtpasswdLoginModule
implements LoginModule {
    private static final Logger log = LoggerFactory.getLogger(HtpasswdLoginModule.class);
    private String realm;
    private Subject subject;
    private CallbackHandler handler;
    private Map<String, ?> options;
    private Map<String, ?> sharedState;
    private boolean succeeded;
    private String name;
    private List<HtpasswdGroup> groups;
    private Map<String, String> claims;

    private IHtpasswdAuthService getService() throws LoginException {
        return HtpasswdAuthServiceFactory.getService(this.realm);
    }

    public HtpasswdLoginModule() {
        if (log.isDebugEnabled()) {
            log.debug("HtpasswdLoginModule constructed.");
        }
    }

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.options = options;
        this.handler = callbackHandler;
        this.sharedState = sharedState;
        if (log.isDebugEnabled()) {
            log.debug("HtpasswdLoginModule initialized with options [{}] and shared state [{}]", options, sharedState);
        }
        this.realm = (String)this.options.get("jaas.realmName");
        if (this.realm == null) {
            throw new IllegalArgumentException("LoginModule parameters contain no [jaas.realmName] option.");
        }
    }

    @Override
    public boolean login() throws LoginException {
        boolean result;
        Callback[] callbacks;
        String prename;
        Set<Principal> preauthenticated = this.subject.getPrincipals();
        if (preauthenticated.size() == 1) {
            HtpasswdPrincipal principal = (HtpasswdPrincipal)preauthenticated.iterator().next();
            if (!this.realm.equals(principal.getRealm())) {
                throw new LoginException("Realm [" + principal.getRealm() + "] of pre-authenticated user differs from [" + this.realm + "]");
            }
            prename = principal.getName();
            if (log.isDebugEnabled()) {
                log.debug("login() called with pre-authenticated user[{}].", (Object)prename);
            }
            callbacks = new Callback[]{new NameCallback("Name")};
        } else {
            if (log.isDebugEnabled()) {
                log.debug("login() called without pre-authenticated user.");
            }
            prename = null;
            callbacks = new Callback[]{new NameCallback("Name"), new PasswordCallback("Password", false)};
        }
        try {
            this.handler.handle(callbacks);
        }
        catch (IOException e) {
            throw new LoginException(e.getMessage());
        }
        catch (UnsupportedCallbackException e) {
            throw new LoginException(e.getMessage());
        }
        String name = ((NameCallback)callbacks[0]).getName();
        IHtpasswdAuthService svc = this.getService();
        if (prename == null) {
            char[] password = ((PasswordCallback)callbacks[1]).getPassword();
            if (log.isDebugEnabled()) {
                log.debug("login() is checking password for user [{}].", (Object)name);
            }
            result = svc.authenticate(name, password);
            if (log.isDebugEnabled()) {
                log.debug("login() has checked password for user [{}] with result [{}].", (Object)name, (Object)result);
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug("login() is checking pre-authenticated user [{}].", (Object)name);
            }
            result = prename.equals(name);
            if (log.isDebugEnabled()) {
                log.debug("login() has checked pre-authenticated user [{}] with result [{}].", (Object)name, (Object)result);
            }
        }
        this.succeeded = result;
        this.name = name;
        this.groups = svc.getUserGroups(this.name);
        this.claims = svc.getUserClaims(this.name);
        return result;
    }

    @Override
    public boolean commit() throws LoginException {
        if (this.succeeded) {
            this.subject.getPrincipals().add(new HtpasswdPrincipal(this.name, this.realm));
            if (this.groups != null) {
                this.subject.getPublicCredentials().addAll(this.groups);
            }
            if (this.claims != null) {
                this.subject.getPublicCredentials().add(this.claims);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean abort() throws LoginException {
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        boolean ret = this.succeeded;
        this.succeeded = false;
        return ret;
    }
}

