/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.htpasswd.jaas;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import javax.security.auth.login.LoginException;
import org.clazzes.login.htpasswd.jaas.HtpasswdAuthService;
import org.clazzes.login.htpasswd.jaas.HtpasswdAuthServiceFactoryConfiguration;
import org.clazzes.login.htpasswd.jaas.IHtpasswdAuthService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HtpasswdAuthServiceFactory {
    private HtpasswdAuthServiceFactoryConfiguration config;
    private static final Logger log = LoggerFactory.getLogger(HtpasswdAuthServiceFactory.class);
    private static final Pattern REALM_RX = Pattern.compile("^[a-zA-Z][a-zA-Z0-9_-]*$");
    private final ConcurrentMap<String, HtpasswdAuthService> authServicesByRealm = new ConcurrentHashMap<String, HtpasswdAuthService>();
    private static HtpasswdAuthServiceFactory DEFAULT_INSTANCE = new HtpasswdAuthServiceFactoryConfiguration().build();

    public void setConfig(HtpasswdAuthServiceFactoryConfiguration config) {
        Objects.requireNonNull(config);
        this.config = config;
    }

    public HtpasswdAuthServiceFactory(HtpasswdAuthServiceFactoryConfiguration config) {
        Objects.requireNonNull(config);
        this.config = config;
    }

    private void resolveFile(String filename, Consumer<Path> readFile, Consumer<String> readFileContent) throws LoginException {
        if (this.config.getHtpasswdFileContents() != null) {
            readFileContent.accept(this.config.getHtpasswdFileContents().get(filename));
        } else {
            Path htpasswdDir = Optional.ofNullable(this.config.getHtpasswdDir()).or(() -> Optional.ofNullable(System.getProperty("login.htpasswd.etcDir")).map(x$0 -> Path.of(x$0, new String[0]))).or(() -> Optional.ofNullable(System.getProperty("svc.runner.etcPath")).map(svcRunnerEtcPath -> Path.of(svcRunnerEtcPath, new String[0]).resolve("htpasswd.d"))).orElseThrow(() -> new LoginException("Could not find property [htpasswd.etcDir] nor system property [login.htpasswd.etcDir] or [svc.runner.etcPath], please check your configuration."));
            if (!Files.exists(htpasswdDir, new LinkOption[0])) {
                log.warn("Htpasswd directory [{}] does not exist, check your configuration.", (Object)htpasswdDir);
            }
            readFile.accept(htpasswdDir.resolve(filename));
        }
    }

    public final IHtpasswdAuthService getServiceConfigurable(String realm) throws LoginException {
        Objects.requireNonNull(realm);
        if (!REALM_RX.matcher(realm).matches()) {
            throw new IllegalArgumentException("Inavlid realm name [" + realm + "] (must match " + String.valueOf(REALM_RX) + ")");
        }
        HtpasswdAuthService svc = (HtpasswdAuthService)this.authServicesByRealm.get(realm);
        if (svc == null || svc.needsUpdate()) {
            HtpasswdAuthService fsvc = svc = new HtpasswdAuthService();
            this.resolveFile(realm + ".htpasswd", filePath -> fsvc.read((Path)filePath), content -> fsvc.readString((String)content));
            this.resolveFile(realm + ".group", filePath -> fsvc.readGroupPath((Path)filePath), content -> fsvc.readGroupString((String)content));
            this.resolveFile(realm + ".claims", filePath -> fsvc.readClaimsPath((Path)filePath), content -> fsvc.readClaimsString((String)content));
            log.info("Initialized htpasswd JAAS login module for realm [{}]", (Object)realm);
            this.authServicesByRealm.put(realm, svc);
        }
        return svc;
    }

    public static void debugClear() {
        DEFAULT_INSTANCE = new HtpasswdAuthServiceFactoryConfiguration().build();
    }

    public static IHtpasswdAuthService getService(String realm) throws LoginException {
        return DEFAULT_INSTANCE.getServiceConfigurable(realm);
    }
}

