/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.util.sec;

import org.clazzes.util.sec.HashTools;
import org.clazzes.util.sec.HasherFactory;
import org.clazzes.util.sec.PasswordHasher;
import org.clazzes.util.sec.PasswordHasherFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hasher {
    private static final Logger log = LoggerFactory.getLogger(Hasher.class);
    protected static PasswordHasherFactory passwordHasherFactory;

    public static void main(String[] args) throws Exception {
        PasswordHasher pwhasher;
        String algo_name;
        passwordHasherFactory = new HasherFactory();
        String command = System.getenv("CMD");
        if (command == null || command.length() == 0) {
            command = "hash";
            log.info("Using default CMD hash");
        } else {
            log.info("Using given CMD " + command);
        }
        String pwcleartext = System.getenv("PW");
        if (pwcleartext == null || pwcleartext.length() == 0) {
            log.error("No PW given.");
            System.exit(2);
        } else {
            log.info("Using given PW " + pwcleartext);
        }
        if (command.equals("hash")) {
            String salt = System.getenv("SALT");
            if (salt == null || salt.length() == 0) {
                salt = HashTools.randomSalt();
                log.info("No SALT given, using random salt " + salt);
            } else {
                log.info("Using given SALT " + salt);
            }
            algo_name = System.getenv("ALG");
            if (algo_name == null || algo_name.length() == 0) {
                algo_name = "SSHA1";
                log.info("No ALG given, using default algorithm " + algo_name);
            } else {
                log.info("Using given ALG " + algo_name);
            }
            pwhasher = passwordHasherFactory.getPasswordHasher(algo_name);
            if (pwhasher == null) {
                log.error("Could not find hasher for algorithm " + algo_name);
                System.exit(3);
            } else {
                log.info("Got PasswordHasher of class " + pwhasher.getClass().getName());
                String hashed = pwhasher.hashPassword(pwcleartext, salt);
                log.info("Computed password to " + hashed);
                System.exit(0);
            }
        }
        if (command.equals("check")) {
            String hashed = System.getenv("HASHED");
            if (hashed == null || hashed.length() == 0) {
                log.error("No HASHED pw given to check");
                System.exit(4);
            } else {
                log.info("Using HASHED " + hashed);
            }
            algo_name = HashTools.parseAlorithmName(hashed);
            log.info("Parsed algo_name to " + algo_name);
            pwhasher = passwordHasherFactory.getPasswordHasher(algo_name);
            if (pwhasher == null) {
                log.error("Could not find hasher for algorithm " + algo_name);
                System.exit(5);
            } else {
                log.info("Got PasswordHasher of class " + pwhasher.getClass().getName());
                boolean pwok = pwhasher.checkPassword(pwcleartext, hashed);
                log.info("The PW seems to be " + (pwok ? "OK" : "WRONG"));
                System.exit(0);
            }
        }
        log.error("What did you want? " + command + "?");
        System.exit(1);
    }
}

