/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.util.sec;

import java.security.SecureRandom;
import org.clazzes.util.sec.PasswordHasher;
import org.clazzes.util.sec.PasswordHasherFactory;

public class HashTools {
    public static final byte DEFAULT_SALTLENGTH = 4;
    public static final String CRYPT_SALT_CHARS = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ./";
    public static final String B64_SALT_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_";
    public static final String SMS_SALT_CHARS = "abcdefghkmnpqrstuvwxyz0123456789";
    private static final SecureRandom secureRandom = new SecureRandom();

    public static final SecureRandom getSecureRandom() {
        return secureRandom;
    }

    public static String randomSalt() {
        return HashTools.randomSalt(4);
    }

    public static String randomSalt(int length, String saltChars) {
        if (length <= 0 || length > 256) {
            throw new RuntimeException("HashTools.randomSalt(" + length + "): Illegal length " + length);
        }
        char[] salt = new char[length];
        for (int i = 0; i < length; ++i) {
            salt[i] = saltChars.charAt(secureRandom.nextInt(saltChars.length()));
        }
        return new String(salt);
    }

    public static String randomSalt(int length) {
        return HashTools.randomSalt(length, CRYPT_SALT_CHARS);
    }

    public static String randomSaltBase64(int length) {
        return HashTools.randomSalt(length, B64_SALT_CHARS);
    }

    public static String randomSaltSms(int length) {
        return HashTools.randomSalt(length, SMS_SALT_CHARS);
    }

    public static String parseAlorithmName(String from_hashed_password) {
        if (from_hashed_password == null) {
            return null;
        }
        int left_idx = from_hashed_password.indexOf(123);
        if (left_idx != 0) {
            return null;
        }
        int right_idx = from_hashed_password.lastIndexOf(125);
        if (right_idx < 0) {
            return null;
        }
        if (right_idx - left_idx < 2) {
            return null;
        }
        String algo_name = from_hashed_password.substring(left_idx + 1, right_idx);
        return algo_name;
    }

    public static boolean checkPassword(PasswordHasherFactory passwordHasherFactory, String givenPassword, String hashedPassword) {
        if (hashedPassword == null || givenPassword == null) {
            return false;
        }
        String algoName = HashTools.parseAlorithmName(hashedPassword);
        if (algoName == null || algoName.length() == 0) {
            return false;
        }
        PasswordHasher hasher = passwordHasherFactory.getPasswordHasher(algoName);
        if (hasher == null) {
            return false;
        }
        return hasher.checkPassword(givenPassword, hashedPassword);
    }
}

