/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.util.formula.ast;

import org.clazzes.util.formula.SymbolValues;
import org.clazzes.util.formula.ast.BinaryOpFormulaNode;
import org.clazzes.util.formula.ast.FormulaNode;
import org.clazzes.util.formula.ast.FormulaNodeVisitor;

public class SwitchFormulaNode
extends BinaryOpFormulaNode {
    private static final long serialVersionUID = 6075427372742958682L;
    private final FormulaNode condition;

    public SwitchFormulaNode(FormulaNode condition, FormulaNode lhs, FormulaNode rhs) {
        super(lhs, rhs);
        this.condition = condition;
    }

    @Override
    public String getOperator() {
        return "?:";
    }

    @Override
    public int getPrecedence() {
        return 1;
    }

    @Override
    public double evaluate(SymbolValues symbols) {
        return this.condition.evaluate(symbols) != 0.0 ? this.getLhs().evaluate(symbols) : this.getRhs().evaluate(symbols);
    }

    @Override
    public void accept(FormulaNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String toString() {
        return "[" + this.getOperator() + "," + String.valueOf(this.getCondition()) + "," + String.valueOf(this.getLhs()) + "," + String.valueOf(this.getRhs()) + "]";
    }

    public FormulaNode getCondition() {
        return this.condition;
    }
}

