/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.util.formula.ast;

import java.text.Format;
import java.util.Locale;
import org.clazzes.util.formula.FormulaHelper;
import org.clazzes.util.formula.ast.BinaryOpFormulaNode;
import org.clazzes.util.formula.ast.ConstFormulaNode;
import org.clazzes.util.formula.ast.FormulaNode;
import org.clazzes.util.formula.ast.FormulaNodeVisitor;
import org.clazzes.util.formula.ast.FunctionFormulaNode;
import org.clazzes.util.formula.ast.NegFormulaNode;
import org.clazzes.util.formula.ast.NotFormulaNode;
import org.clazzes.util.formula.ast.SwitchFormulaNode;
import org.clazzes.util.formula.ast.SymbolFormulaNode;
import org.clazzes.util.ryu.RyuNumberFormat;

public class FormattingFormulaNodeVisitor
implements FormulaNodeVisitor {
    private final Format numberFormat;
    private final int options;
    private final StringBuffer sb = new StringBuffer();

    public FormattingFormulaNodeVisitor(Format numberFormat, int options) {
        this.numberFormat = numberFormat;
        this.options = options;
    }

    public FormattingFormulaNodeVisitor(Locale locale, int options) {
        this(new RyuNumberFormat(locale), options);
    }

    public FormattingFormulaNodeVisitor(Locale locale) {
        this(new RyuNumberFormat(locale), 0);
    }

    public FormattingFormulaNodeVisitor() {
        this((Format)null, 0);
    }

    @Override
    public void visit(ConstFormulaNode constFormulaNode) {
        if (this.numberFormat == null) {
            this.sb.append(constFormulaNode.getValue());
        } else {
            this.numberFormat.format(constFormulaNode.getValue(), this.sb, null);
        }
    }

    @Override
    public void visit(SymbolFormulaNode symbolFormulaNode) {
        this.sb.append(symbolFormulaNode.getSymbol());
    }

    @Override
    public void visitBinary(BinaryOpFormulaNode binaryOpFormulaNode) {
        FormulaNode lhs = binaryOpFormulaNode.getLhs();
        FormulaNode rhs = binaryOpFormulaNode.getRhs();
        if (FormulaHelper.needLeftBraces(binaryOpFormulaNode.getPrecedence(), lhs.getPrecedence())) {
            this.sb.append('(');
            lhs.accept(this);
            this.sb.append(')');
        } else {
            lhs.accept(this);
        }
        this.sb.append(binaryOpFormulaNode.getOperator());
        if (FormulaHelper.needRightBraces(binaryOpFormulaNode.getPrecedence(), rhs.getPrecedence())) {
            this.sb.append('(');
            rhs.accept(this);
            this.sb.append(')');
        } else {
            rhs.accept(this);
        }
    }

    @Override
    public void visit(FunctionFormulaNode functionFormulaNode) {
        String f = functionFormulaNode.getOperator();
        if ((this.options & 1) != 0) {
            switch (f) {
                case "log": {
                    this.sb.append("ln");
                    break;
                }
                case "log10": {
                    this.sb.append("log");
                    break;
                }
                case "signum": {
                    this.sb.append("sgn");
                    break;
                }
                default: {
                    this.sb.append(f);
                    break;
                }
            }
        } else {
            this.sb.append(f);
        }
        this.sb.append('(');
        functionFormulaNode.getRhs().accept(this);
        this.sb.append(')');
    }

    @Override
    public void visit(NegFormulaNode negFormulaNode) {
        FormulaNode rhs = negFormulaNode.getRhs();
        if (rhs.getPrecedence() >= 0 && rhs.getPrecedence() < negFormulaNode.getPrecedence()) {
            this.sb.append("-(");
            negFormulaNode.getRhs().accept(this);
            this.sb.append(')');
        } else {
            this.sb.append('-');
            negFormulaNode.getRhs().accept(this);
        }
    }

    @Override
    public void visit(NotFormulaNode notFormulaNode) {
        FormulaNode rhs = notFormulaNode.getRhs();
        if (rhs.getPrecedence() >= 0 && rhs.getPrecedence() < notFormulaNode.getPrecedence()) {
            this.sb.append("!(");
            notFormulaNode.getRhs().accept(this);
            this.sb.append(')');
        } else {
            this.sb.append('!');
            notFormulaNode.getRhs().accept(this);
        }
    }

    @Override
    public void visit(SwitchFormulaNode switchOpFormulaNode) {
        FormulaNode cond = switchOpFormulaNode.getCondition();
        FormulaNode lhs = switchOpFormulaNode.getLhs();
        FormulaNode rhs = switchOpFormulaNode.getRhs();
        if (FormulaHelper.needLeftBraces(switchOpFormulaNode.getPrecedence(), cond.getPrecedence())) {
            this.sb.append('(');
            cond.accept(this);
            this.sb.append(')');
        } else {
            cond.accept(this);
        }
        this.sb.append('?');
        if (FormulaHelper.needLeftBraces(switchOpFormulaNode.getPrecedence(), lhs.getPrecedence())) {
            this.sb.append('(');
            lhs.accept(this);
            this.sb.append(')');
        } else {
            lhs.accept(this);
        }
        this.sb.append(':');
        if (FormulaHelper.needRightBraces(switchOpFormulaNode.getPrecedence(), rhs.getPrecedence())) {
            this.sb.append('(');
            rhs.accept(this);
            this.sb.append(')');
        } else {
            rhs.accept(this);
        }
    }

    public String toString() {
        return this.sb.toString();
    }

    public void clear() {
        this.sb.setLength(0);
    }
}

