/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.util.formula;

import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.clazzes.util.formula.FormulaHelper;
import org.clazzes.util.formula.SymbolValues;
import org.clazzes.util.formula.ast.AndFormulaNode;
import org.clazzes.util.formula.ast.ConstFormulaNode;
import org.clazzes.util.formula.ast.DivideFormulaNode;
import org.clazzes.util.formula.ast.EqualsFormulaNode;
import org.clazzes.util.formula.ast.FormulaNode;
import org.clazzes.util.formula.ast.FunctionFormulaNode;
import org.clazzes.util.formula.ast.GeqFormulaNode;
import org.clazzes.util.formula.ast.GreaterFormulaNode;
import org.clazzes.util.formula.ast.LeqFormulaNode;
import org.clazzes.util.formula.ast.LessFormulaNode;
import org.clazzes.util.formula.ast.MinusFormulaNode;
import org.clazzes.util.formula.ast.MultiplyFormulaNode;
import org.clazzes.util.formula.ast.NegFormulaNode;
import org.clazzes.util.formula.ast.NeqFormulaNode;
import org.clazzes.util.formula.ast.NotFormulaNode;
import org.clazzes.util.formula.ast.OrFormulaNode;
import org.clazzes.util.formula.ast.PlusFormulaNode;
import org.clazzes.util.formula.ast.PowerFormulaNode;
import org.clazzes.util.formula.ast.SwitchFormulaNode;
import org.clazzes.util.formula.ast.SymbolFormulaNode;
import org.clazzes.util.formula.ast.UnaryOpFormulaNode;

public class FormulaEvaluator {
    private static final Map<String, Character> LEGACY_BUILTIN_FUNCTIONS = new HashMap<String, Character>();
    private static final Map<String, Character> BUILTIN_FUNCTIONS;
    private static final Map<Character, String> REV_BUILTIN_FUNCTIONS;
    private static final char NE = '\u2260';
    private static final char LE = '\u2264';
    private static final char GE = '\u2265';
    private final String expr;
    private final List<Token> stack;
    private final Map<Token, FormulaNode> nodeStack;
    private final NumberFormat numberFormat;
    private final SymbolValues symValues;
    private final int options;

    private FormulaEvaluator(Locale locale, String expr, SymbolValues symValues, int options, boolean nodesEnabled) {
        this.expr = expr;
        this.stack = new ArrayList<Token>(16);
        this.numberFormat = NumberFormat.getInstance(locale);
        this.numberFormat.setGroupingUsed(false);
        this.symValues = symValues;
        this.options = options;
        this.nodeStack = nodesEnabled ? new HashMap(16) : null;
    }

    private final boolean isIdentifierPart(char c) {
        if (Character.isJavaIdentifierPart(c)) {
            return true;
        }
        if ((this.options & 2) != 0 && c == '.') {
            return true;
        }
        return (this.options & 4) != 0 && (c == '[' || c == ']');
    }

    private boolean pushToken(ParsePosition pos) throws ParseException {
        pos.setErrorIndex(-1);
        while (pos.getIndex() < this.expr.length() && Character.isWhitespace(this.expr.charAt(pos.getIndex()))) {
            pos.setIndex(pos.getIndex() + 1);
        }
        if (pos.getIndex() >= this.expr.length()) {
            this.stack.add(new Token('\u0000', 0));
            return false;
        }
        int oidx = pos.getIndex();
        char c = this.expr.charAt(oidx);
        Token token = null;
        double sign = 1.0;
        switch (c) {
            case '^': {
                token = new Token(c, 8);
                break;
            }
            case '*': 
            case '/': {
                token = new Token(c, 7);
                break;
            }
            case '-': {
                if (this.stack.size() <= 0 || this.stack.get((int)(this.stack.size() - 1)).precedence > 0) {
                    ++oidx;
                    while (oidx < this.expr.length() && Character.isWhitespace(this.expr.charAt(oidx))) {
                        ++oidx;
                    }
                    if (oidx >= this.expr.length()) {
                        throw new ParseException("Unexpected end of formula [" + this.expr + "] after minus sign.", oidx);
                    }
                    sign = -1.0;
                    c = this.expr.charAt(oidx);
                    if (c == '-') {
                        throw new ParseException("Formula [" + this.expr + "] contains superfluous minus signs.", oidx);
                    }
                    pos.setIndex(oidx);
                    if (c != '(') break;
                    token = new Token(c, sign);
                    break;
                }
            }
            case '+': {
                token = new Token(c, 6);
                break;
            }
            case '<': 
            case '>': {
                if (oidx + 1 < this.expr.length() && this.expr.charAt(oidx + 1) == '=') {
                    ++oidx;
                    token = new Token(c == '<' ? (char)'\u2264' : '\u2265', 5);
                    break;
                }
                token = new Token(c, 5);
                break;
            }
            case '\u2264': 
            case '\u2265': {
                token = new Token(c, 5);
                break;
            }
            case '!': 
            case '=': {
                if (oidx + 1 < this.expr.length() && this.expr.charAt(oidx + 1) == '=') {
                    ++oidx;
                    token = new Token(c == '=' ? (char)'=' : '\u2260', 4);
                    break;
                }
                if (c != '!') break;
                token = new Token(c, 9);
                break;
            }
            case '\u2260': {
                token = new Token(c, 4);
                break;
            }
            case '&': {
                if (oidx + 1 >= this.expr.length() || this.expr.charAt(oidx + 1) != '&') break;
                ++oidx;
                token = new Token('&', 3);
                break;
            }
            case '|': {
                if (oidx + 1 >= this.expr.length() || this.expr.charAt(oidx + 1) != '|') break;
                ++oidx;
                token = new Token('|', 2);
                break;
            }
            case ':': 
            case '?': {
                token = new Token(c, 1);
                break;
            }
            case ')': {
                token = new Token(c, 0);
                break;
            }
            case '(': {
                token = new Token(c, 15);
            }
        }
        if (token == null) {
            if (Character.isJavaIdentifierStart(c)) {
                int idx;
                for (idx = oidx + 1; idx < this.expr.length() && this.isIdentifierPart(this.expr.charAt(idx)); ++idx) {
                }
                pos.setIndex(idx);
                String identifier = this.expr.substring(oidx, idx);
                if ((this.options & 4) != 0) {
                    int fio = identifier.indexOf(91);
                    int lio = identifier.lastIndexOf(91);
                    int fic = identifier.indexOf(93);
                    int lic = identifier.lastIndexOf(93);
                    if (fio != lio) {
                        throw new ParseException("Identifier [" + identifier + "] contains two open brackets.", oidx + fio);
                    }
                    if (fic != lic) {
                        throw new ParseException("Identifier [" + identifier + "] contains two closing brackets.", oidx + fic);
                    }
                    if (fio != -1 && fio >= fic) {
                        throw new ParseException("Identifier [" + identifier + "] contains misaligned brackets.", oidx + fic);
                    }
                }
                Character builtin = null;
                if ((this.options & 1) != 0) {
                    builtin = LEGACY_BUILTIN_FUNCTIONS.get(identifier);
                }
                if (builtin == null) {
                    builtin = BUILTIN_FUNCTIONS.get(identifier);
                }
                if (builtin == null) {
                    Number v;
                    Number number = v = this.symValues == null ? (Number)null : (Number)this.symValues.getSymbolValue(identifier);
                    if (v == null) {
                        throw new ParseException("Unknown symbol [" + identifier + "] specified.", oidx);
                    }
                    if (this.nodeStack != null) {
                        // empty if block
                    }
                    token = new Token(sign * v.doubleValue());
                    if (this.nodeStack != null) {
                        FormulaNode node = new SymbolFormulaNode(identifier);
                        if (sign < 0.0) {
                            node = new NegFormulaNode(node);
                        }
                        this.nodeStack.put(token, node);
                    }
                } else {
                    while (idx < this.expr.length() && Character.isWhitespace(this.expr.charAt(idx))) {
                        ++idx;
                    }
                    if (this.expr.charAt(idx) != '(') {
                        throw new ParseException("Builtin function [" + identifier + "] not followed by an open brace.", idx);
                    }
                    pos.setIndex(++idx);
                    token = new Token(builtin.charValue(), sign);
                }
            } else {
                Number n = this.numberFormat.parse(this.expr, pos);
                if (pos.getIndex() > oidx) {
                    String mantissa;
                    char followup;
                    double v = n.doubleValue();
                    if (pos.getIndex() < this.expr.length() && ((followup = this.expr.charAt(pos.getIndex())) == 'e' || followup == 'E') && (mantissa = this.expr.substring(oidx, pos.getIndex())).indexOf(101) < 0 && mantissa.indexOf(69) < 0 && pos.getIndex() + 1 < this.expr.length() && this.expr.charAt(pos.getIndex() + 1) == '+') {
                        int sidx = pos.getIndex() + 2;
                        pos.setIndex(sidx);
                        this.numberFormat.setParseIntegerOnly(true);
                        Number exp = this.numberFormat.parse(this.expr, pos);
                        this.numberFormat.setParseIntegerOnly(false);
                        if (pos.getIndex() > sidx) {
                            v *= Math.pow(10.0, exp.doubleValue());
                        }
                    }
                    token = new Token(sign * v);
                    if (this.nodeStack != null) {
                        this.nodeStack.put(token, new ConstFormulaNode(sign * n.doubleValue()));
                    }
                }
            }
        } else {
            pos.setIndex(oidx + 1);
        }
        if (token == null) {
            throw new ParseException("Unknown operator [" + c + "]", oidx);
        }
        this.stack.add(token);
        return true;
    }

    private boolean reduce() {
        int l = this.stack.size() - 1;
        if (l < 2) {
            return false;
        }
        Token last = this.stack.get(l);
        Token last1 = this.stack.get(l - 1);
        Token last2 = this.stack.get(l - 2);
        if (last2.precedence == 9 && last1.precedence < 0 && last.precedence < 9) {
            last1.value = FormulaHelper.booleanToDouble(last1.value == 0.0);
            this.stack.remove(l - 2);
            return true;
        }
        if (l < 3) {
            return false;
        }
        Token last3 = this.stack.get(l - 3);
        if (l >= 5 && last2.precedence == 1 && last2.operator == ':' && (last.precedence < 1 || last.operator == ':') && last3.precedence < 0 && last1.precedence < 0) {
            Token last4 = this.stack.get(l - 4);
            Token last5 = this.stack.get(l - 5);
            if (last4.precedence == 1 && last4.operator == '?' && last5.precedence < 0) {
                last5.value = last5.value != 0.0 ? last3.value : last1.value;
                this.stack.remove(l - 1);
                this.stack.remove(l - 2);
                this.stack.remove(l - 3);
                this.stack.remove(l - 4);
                return true;
            }
        }
        if (last3.precedence == 15 && last2.precedence < 0 && last1.operator == ')') {
            switch (last3.operator) {
                case '2': {
                    last2.value = last3.value * Math.sqrt(last2.value);
                    break;
                }
                case 'e': {
                    last2.value = last3.value * Math.exp(last2.value);
                    break;
                }
                case 'l': {
                    last2.value = last3.value * Math.log(last2.value);
                    break;
                }
                case 'L': {
                    last2.value = last3.value * Math.log10(last2.value);
                    break;
                }
                case 's': {
                    last2.value = last3.value * Math.sin(last2.value);
                    break;
                }
                case 'c': {
                    last2.value = last3.value * Math.cos(last2.value);
                    break;
                }
                case 't': {
                    last2.value = last3.value * Math.tan(last2.value);
                    break;
                }
                case 'S': {
                    last2.value = last3.value * Math.asin(last2.value);
                    break;
                }
                case 'C': {
                    last2.value = last3.value * Math.acos(last2.value);
                    break;
                }
                case 'T': {
                    last2.value = last3.value * Math.atan(last2.value);
                    break;
                }
                case 'a': {
                    last2.value = last3.value * Math.abs(last2.value);
                    break;
                }
                case 'A': {
                    last2.value = last3.value * Math.signum(last2.value);
                    break;
                }
                default: {
                    last2.value *= last3.value;
                }
            }
            this.stack.set(l - 3, last2);
            this.stack.set(l - 2, this.stack.remove(l));
            this.stack.remove(l - 1);
            return true;
        }
        if (last3.precedence < 0 && last1.precedence < 0) {
            if (last2.precedence < last.precedence) {
                return false;
            }
            if (last.precedence == 8 && last2.precedence == 8) {
                return false;
            }
            switch (last2.operator) {
                case '+': {
                    last3.value += last1.value;
                    break;
                }
                case '-': {
                    last3.value -= last1.value;
                    break;
                }
                case '*': {
                    last3.value *= last1.value;
                    break;
                }
                case '/': {
                    last3.value /= last1.value;
                    break;
                }
                case '^': {
                    last3.value = Math.pow(last3.value, last1.value);
                    break;
                }
                case '<': {
                    last3.value = FormulaHelper.booleanToDouble(last3.value < last1.value);
                    break;
                }
                case '>': {
                    last3.value = FormulaHelper.booleanToDouble(last3.value > last1.value);
                    break;
                }
                case '\u2264': {
                    last3.value = FormulaHelper.booleanToDouble(last3.value <= last1.value);
                    break;
                }
                case '\u2265': {
                    last3.value = FormulaHelper.booleanToDouble(last3.value >= last1.value);
                    break;
                }
                case '=': {
                    last3.value = FormulaHelper.booleanToDouble(last3.value == last1.value);
                    break;
                }
                case '\u2260': {
                    last3.value = FormulaHelper.booleanToDouble(last3.value != last1.value);
                    break;
                }
                case '&': {
                    last3.value = FormulaHelper.booleanToDouble(last3.value != 0.0 && last1.value != 0.0);
                    break;
                }
                case '|': {
                    last3.value = FormulaHelper.booleanToDouble(last3.value != 0.0 || last1.value != 0.0);
                    break;
                }
                default: {
                    return false;
                }
            }
            this.stack.set(l - 2, this.stack.remove(l));
            this.stack.remove(l - 1);
            return true;
        }
        return false;
    }

    private double getValue() throws ParseException {
        if (this.stack.size() != 2 || this.stack.get((int)0).precedence != -1 || this.stack.get((int)1).operator != '\u0000') {
            throw new ParseException("Cannot reduce formula [" + this.expr + "].", this.expr.length() - 1);
        }
        return this.stack.get((int)0).value;
    }

    private boolean reduceNode() {
        int l = this.stack.size() - 1;
        if (l < 2) {
            return false;
        }
        Token last = this.stack.get(l);
        Token last1 = this.stack.get(l - 1);
        Token last2 = this.stack.get(l - 2);
        if (last2.precedence == 9 && last1.precedence < 0 && last.precedence < 9) {
            this.nodeStack.put(last1, new NotFormulaNode(this.nodeStack.get(last1)));
            this.stack.remove(l - 2);
            return true;
        }
        if (l < 3) {
            return false;
        }
        Token last3 = this.stack.get(l - 3);
        if (l >= 5 && last2.precedence == 1 && last2.operator == ':' && (last.precedence < 1 || last.operator == ':') && last3.precedence < 0 && last1.precedence < 0) {
            Token last4 = this.stack.get(l - 4);
            Token last5 = this.stack.get(l - 5);
            if (last4.precedence == 1 && last4.operator == '?' && last5.precedence < 0) {
                this.nodeStack.put(last5, new SwitchFormulaNode(this.nodeStack.get(last5), this.nodeStack.get(last3), this.nodeStack.get(last1)));
                this.stack.remove(l - 1);
                this.stack.remove(l - 2);
                this.stack.remove(l - 3);
                this.stack.remove(l - 4);
                return true;
            }
        }
        if (last3.precedence == 15 && last2.precedence < 0 && last1.operator == ')') {
            String f = REV_BUILTIN_FUNCTIONS.get(Character.valueOf(last3.operator));
            if (f != null) {
                UnaryOpFormulaNode node = new FunctionFormulaNode(f, this.nodeStack.get(last2));
                if (last3.value < 0.0) {
                    node = new NegFormulaNode(node);
                }
                this.nodeStack.put(last2, node);
            } else if (last3.value < 0.0) {
                this.nodeStack.put(last2, new NegFormulaNode(this.nodeStack.get(last2)));
            }
            this.stack.set(l - 3, last2);
            this.stack.set(l - 2, this.stack.remove(l));
            this.stack.remove(l - 1);
            return true;
        }
        if (last3.precedence < 0 && last1.precedence < 0) {
            if (last2.precedence < last.precedence) {
                return false;
            }
            if (last.precedence == 8 && last2.precedence == 8) {
                return false;
            }
            switch (last2.operator) {
                case '+': {
                    this.nodeStack.put(last3, new PlusFormulaNode(this.nodeStack.get(last3), this.nodeStack.get(last1)));
                    break;
                }
                case '-': {
                    this.nodeStack.put(last3, new MinusFormulaNode(this.nodeStack.get(last3), this.nodeStack.get(last1)));
                    break;
                }
                case '*': {
                    this.nodeStack.put(last3, new MultiplyFormulaNode(this.nodeStack.get(last3), this.nodeStack.get(last1)));
                    break;
                }
                case '/': {
                    this.nodeStack.put(last3, new DivideFormulaNode(this.nodeStack.get(last3), this.nodeStack.get(last1)));
                    break;
                }
                case '^': {
                    this.nodeStack.put(last3, new PowerFormulaNode(this.nodeStack.get(last3), this.nodeStack.get(last1)));
                    break;
                }
                case '<': {
                    this.nodeStack.put(last3, new LessFormulaNode(this.nodeStack.get(last3), this.nodeStack.get(last1)));
                    break;
                }
                case '>': {
                    this.nodeStack.put(last3, new GreaterFormulaNode(this.nodeStack.get(last3), this.nodeStack.get(last1)));
                    break;
                }
                case '\u2264': {
                    this.nodeStack.put(last3, new LeqFormulaNode(this.nodeStack.get(last3), this.nodeStack.get(last1)));
                    break;
                }
                case '\u2265': {
                    this.nodeStack.put(last3, new GeqFormulaNode(this.nodeStack.get(last3), this.nodeStack.get(last1)));
                    break;
                }
                case '=': {
                    this.nodeStack.put(last3, new EqualsFormulaNode(this.nodeStack.get(last3), this.nodeStack.get(last1)));
                    break;
                }
                case '\u2260': {
                    this.nodeStack.put(last3, new NeqFormulaNode(this.nodeStack.get(last3), this.nodeStack.get(last1)));
                    break;
                }
                case '&': {
                    this.nodeStack.put(last3, new AndFormulaNode(this.nodeStack.get(last3), this.nodeStack.get(last1)));
                    break;
                }
                case '|': {
                    this.nodeStack.put(last3, new OrFormulaNode(this.nodeStack.get(last3), this.nodeStack.get(last1)));
                    break;
                }
                default: {
                    return false;
                }
            }
            this.stack.set(l - 2, this.stack.remove(l));
            this.stack.remove(l - 1);
            return true;
        }
        return false;
    }

    private FormulaNode getNodeValue() throws ParseException {
        if (this.stack.size() != 2 || this.stack.get((int)0).precedence != -1 || this.stack.get((int)1).operator != '\u0000') {
            throw new ParseException("Cannot reduce formula [" + this.expr + "].", this.expr.length() - 1);
        }
        return this.nodeStack.get(this.stack.get(0));
    }

    public static double evaluate(Locale locale, String expr, SymbolValues symValues) throws ParseException {
        return FormulaEvaluator.evaluate(locale, expr, symValues, 3);
    }

    public static double evaluate(Locale locale, String expr, SymbolValues symValues, int options) throws ParseException {
        FormulaEvaluator e = new FormulaEvaluator(locale, expr, symValues, options, false);
        ParsePosition pos = new ParsePosition(0);
        while (e.pushToken(pos)) {
            while (e.reduce()) {
            }
        }
        while (e.reduce()) {
        }
        return e.getValue();
    }

    public static Set<String> check(Locale locale, String expr) throws ParseException {
        return FormulaEvaluator.check(locale, expr, 3);
    }

    public static Set<String> check(Locale locale, String expr, int options) throws ParseException {
        RecordingSymbolValues r = new RecordingSymbolValues();
        FormulaEvaluator e = new FormulaEvaluator(locale, expr, r, options, false);
        ParsePosition pos = new ParsePosition(0);
        while (e.pushToken(pos)) {
            while (e.reduce()) {
            }
        }
        while (e.reduce()) {
        }
        e.getValue();
        return r.getSymbols();
    }

    public static FormulaNode parse(Locale locale, String expr, Set<String> symbols) throws ParseException {
        return FormulaEvaluator.parse(locale, expr, symbols, 3);
    }

    public static FormulaNode parse(Locale locale, String expr, Set<String> symbols, int options) throws ParseException {
        RecordingSymbolValues r = symbols == null ? new RecordingSymbolValues() : new RecordingSymbolValues(symbols);
        FormulaEvaluator e = new FormulaEvaluator(locale, expr, r, options, true);
        ParsePosition pos = new ParsePosition(0);
        while (e.pushToken(pos)) {
            while (e.reduceNode()) {
            }
        }
        while (e.reduceNode()) {
        }
        return e.getNodeValue();
    }

    static {
        LEGACY_BUILTIN_FUNCTIONS.put("ln", Character.valueOf('l'));
        LEGACY_BUILTIN_FUNCTIONS.put("log", Character.valueOf('L'));
        LEGACY_BUILTIN_FUNCTIONS.put("sgn", Character.valueOf('A'));
        BUILTIN_FUNCTIONS = new HashMap<String, Character>();
        BUILTIN_FUNCTIONS.put("sqrt", Character.valueOf('2'));
        BUILTIN_FUNCTIONS.put("exp", Character.valueOf('e'));
        BUILTIN_FUNCTIONS.put("log", Character.valueOf('l'));
        BUILTIN_FUNCTIONS.put("log10", Character.valueOf('L'));
        BUILTIN_FUNCTIONS.put("sin", Character.valueOf('s'));
        BUILTIN_FUNCTIONS.put("cos", Character.valueOf('c'));
        BUILTIN_FUNCTIONS.put("tan", Character.valueOf('t'));
        BUILTIN_FUNCTIONS.put("asin", Character.valueOf('S'));
        BUILTIN_FUNCTIONS.put("acos", Character.valueOf('C'));
        BUILTIN_FUNCTIONS.put("atan", Character.valueOf('T'));
        BUILTIN_FUNCTIONS.put("abs", Character.valueOf('a'));
        BUILTIN_FUNCTIONS.put("signum", Character.valueOf('A'));
        REV_BUILTIN_FUNCTIONS = new HashMap<Character, String>();
        REV_BUILTIN_FUNCTIONS.put(Character.valueOf('2'), "sqrt");
        REV_BUILTIN_FUNCTIONS.put(Character.valueOf('e'), "exp");
        REV_BUILTIN_FUNCTIONS.put(Character.valueOf('l'), "log");
        REV_BUILTIN_FUNCTIONS.put(Character.valueOf('L'), "log10");
        REV_BUILTIN_FUNCTIONS.put(Character.valueOf('s'), "sin");
        REV_BUILTIN_FUNCTIONS.put(Character.valueOf('c'), "cos");
        REV_BUILTIN_FUNCTIONS.put(Character.valueOf('t'), "tan");
        REV_BUILTIN_FUNCTIONS.put(Character.valueOf('S'), "asin");
        REV_BUILTIN_FUNCTIONS.put(Character.valueOf('C'), "acos");
        REV_BUILTIN_FUNCTIONS.put(Character.valueOf('T'), "atan");
        REV_BUILTIN_FUNCTIONS.put(Character.valueOf('a'), "abs");
        REV_BUILTIN_FUNCTIONS.put(Character.valueOf('A'), "signum");
    }

    private static final class Token {
        public final char operator;
        public final int precedence;
        public double value;

        public Token(char operator, int precedence) {
            this.operator = operator;
            this.precedence = precedence;
            this.value = 1.0;
        }

        public Token(char operator, double sign) {
            this.operator = operator;
            this.precedence = 15;
            this.value = sign;
        }

        public Token(double value) {
            this.operator = (char)32;
            this.precedence = -1;
            this.value = value;
        }

        public String toString() {
            if (this.operator == '\u0000') {
                return "EOS";
            }
            if (this.precedence < 0) {
                return String.valueOf(this.value);
            }
            return String.valueOf(this.operator);
        }
    }

    private static final class RecordingSymbolValues
    implements SymbolValues {
        private final Set<String> symbols;

        public RecordingSymbolValues() {
            this.symbols = new HashSet<String>();
        }

        public RecordingSymbolValues(Set<String> symbols) {
            this.symbols = symbols;
        }

        @Override
        public Number getSymbolValue(String sym) {
            this.symbols.add(sym);
            return Double.NaN;
        }

        public Set<String> getSymbols() {
            return this.symbols;
        }
    }
}

