/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.util.datetime;

import java.io.Serializable;
import java.text.ParseException;
import java.util.Calendar;
import java.util.TimeZone;
import javax.persistence.Embeddable;
import javax.persistence.Transient;
import org.clazzes.util.datetime.ISO8601Format;

@Embeddable
public class UtcTimestamp
implements Serializable,
Comparable<UtcTimestamp>,
Cloneable {
    private static final long serialVersionUID = -4171006885461716579L;
    public static final long MILLISECONDS_PER_SECOND = 1000L;
    public static final long MILLISECONDS_PER_MINUTE = 60000L;
    public static final long MILLISECONDS_PER_HOUR = 3600000L;
    public static final long MILLISECONDS_PER_DAY = 86400000L;
    private static final long REF_DAY = 2440588L;
    private static final long REF_TIMESTAMP = 210866803200000L;
    private static final int[] DAYS_IN_MONTH = new int[]{29, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final TimeZone utcTimezone = TimeZone.getTimeZone("UTC");
    private Long utcMillis;
    private Integer tzOffset;
    private transient DateFields dateFields;

    @Transient
    private long getLocalTimestamp() {
        if (this.utcMillis == null) {
            return 0L;
        }
        long ts = this.utcMillis;
        if (this.tzOffset != null) {
            ts += (long)this.tzOffset.intValue() * 60000L;
        }
        return ts + 210866803200000L;
    }

    private void initDateFields() {
        if (this.utcMillis == null) {
            this.dateFields = new DateFields(0, 0, 0);
            return;
        }
        long linear_day = this.getLocalTimestamp();
        if ((linear_day /= 86400000L) < 2363522L || linear_day > 5373484L) {
            this.dateFields = new DateFields(0, 0, 0);
            return;
        }
        long j = linear_day - 1721119L;
        long y = (j * 4L - 1L) / 146097L;
        j = j * 4L - 146097L * y - 1L;
        long x = j / 4L;
        j = (x * 4L + 3L) / 1461L;
        y = 100L * y + j;
        x = x * 4L + 3L - 1461L * j;
        x = (x + 4L) / 4L;
        long m = (5L * x - 3L) / 153L;
        x = 5L * x - 3L - 153L * m;
        long d = (x + 5L) / 5L;
        if (m < 10L) {
            m += 3L;
        } else {
            m -= 9L;
            ++y;
        }
        this.dateFields = new DateFields((int)y, (int)m, (int)d);
    }

    private static long makeUtcMillis(int year, int month, int day) {
        long y = year;
        long m = month;
        if (m > 2L) {
            m -= 3L;
        } else {
            m += 9L;
            --y;
        }
        long c = y;
        long ya = y - 100L * (c /= 100L);
        long linear_day = (long)(1721119 + day) + 146097L * c / 4L + 1461L * ya / 4L + (153L * m + 2L) / 5L;
        return (linear_day -= 2440588L) * 86400000L;
    }

    public static boolean isLeapYear(int y) {
        return y % 4 == 0 && (y % 400 == 0 || y % 100 != 0);
    }

    public static int getDaysOfMonth(int y, int m) {
        if (m < 1 || m > 12) {
            return 0;
        }
        if (m == 2 && UtcTimestamp.isLeapYear(y)) {
            m = 0;
        }
        return DAYS_IN_MONTH[m];
    }

    public UtcTimestamp() {
        this(System.currentTimeMillis(), 0);
    }

    public UtcTimestamp(UtcTimestamp a) {
        if (a == null) {
            this.tzOffset = null;
            this.utcMillis = null;
        } else {
            this.tzOffset = a.tzOffset;
            this.utcMillis = a.utcMillis;
        }
    }

    public UtcTimestamp(Calendar c) {
        this.setFromCalendar(c);
    }

    public UtcTimestamp(long millis) {
        this(millis, 0);
    }

    public UtcTimestamp(TimeZone timeZone, long millis) {
        this(millis, timeZone.getOffset(millis) / 60000);
    }

    public UtcTimestamp(TimeZone timeZone) {
        this(timeZone, System.currentTimeMillis());
    }

    public UtcTimestamp(long millis, int tzOffset) {
        this.utcMillis = millis;
        this.tzOffset = tzOffset;
    }

    public UtcTimestamp(String s) throws ParseException {
        this.setString(s, null);
    }

    public UtcTimestamp(String s, TimeZone timeZone) throws ParseException {
        this.setString(s, timeZone);
    }

    public static UtcTimestamp now() {
        return new UtcTimestamp(TimeZone.getDefault());
    }

    public static UtcTimestamp now(int tzOffset) {
        return new UtcTimestamp(System.currentTimeMillis(), tzOffset);
    }

    public static UtcTimestamp now(TimeZone timeZone) {
        return new UtcTimestamp(timeZone);
    }

    public Calendar toCalendar() {
        if (this.utcMillis == null || this.tzOffset == null) {
            return null;
        }
        Calendar c = Calendar.getInstance(utcTimezone);
        c.setTimeInMillis(this.utcMillis + (long)this.tzOffset.intValue() * 60000L);
        c.set(15, this.tzOffset * 60000);
        return c;
    }

    @Transient
    public void setFromCalendar(Calendar c) {
        if (c != null) {
            this.utcMillis = c.getTimeInMillis();
            this.tzOffset = (c.get(15) + c.get(16)) / 60000;
        } else {
            this.utcMillis = null;
            this.tzOffset = null;
        }
        this.dateFields = null;
    }

    public Integer getTzOffset() {
        return this.tzOffset;
    }

    public void setTzOffset(Integer tzOffset) {
        this.tzOffset = tzOffset;
        this.dateFields = null;
    }

    public Long getUtcMillis() {
        return this.utcMillis;
    }

    public void setUtcMillis(Long utcMillis) {
        this.utcMillis = utcMillis;
        this.dateFields = null;
    }

    @Transient
    public void setDate(int year, int month, int day) {
        long ts = UtcTimestamp.makeUtcMillis(year, month, day);
        if (this.tzOffset != null) {
            ts -= (long)this.tzOffset.intValue() * 60000L;
        }
        this.utcMillis = ts;
        this.dateFields = null;
    }

    @Transient
    public void setDateTime(int year, int month, int day, int millisOfDay, TimeZone timeZone) {
        int noff = timeZone.getRawOffset();
        long ts = UtcTimestamp.makeUtcMillis(year, month, day) - (long)noff + (long)millisOfDay;
        int off = timeZone.getOffset(ts);
        if (off != noff) {
            ts += (long)(noff - off);
        }
        this.tzOffset = off / 60000;
        this.utcMillis = ts;
        this.dateFields = null;
    }

    @Transient
    public void setDateTime(int year, int month, int day, int hour, int minute, int second, int ms, TimeZone timeZone) {
        this.setDateTime(year, month, day, hour * 3600000 + minute * 60000 + second * 1000 + ms, timeZone);
    }

    @Transient
    public void setDateTime(int year, int month, int day, int hour, int minute, int second, TimeZone timeZone) {
        this.setDateTime(year, month, day, hour * 3600000 + minute * 60000 + second * 1000, timeZone);
    }

    @Transient
    public void setTimeOfDay(int hour, int minute, int second) {
        this.setTimeOfDay(hour, minute, second, 0);
    }

    @Transient
    public void setTimeOfDay(int hour, int minute, int second, int millis) {
        long ts = this.getLocalTimestamp();
        ts = ts / 86400000L * 86400000L + (long)hour * 3600000L + (long)minute * 60000L + (long)second * 1000L + (long)millis;
        if (this.tzOffset != null) {
            ts -= (long)this.tzOffset.intValue() * 60000L;
        }
        this.utcMillis = ts - 210866803200000L;
        this.dateFields = null;
    }

    @Transient
    public int getYear() {
        if (this.dateFields == null) {
            this.initDateFields();
        }
        return this.dateFields.year;
    }

    @Transient
    public int getMonth() {
        if (this.dateFields == null) {
            this.initDateFields();
        }
        return this.dateFields.month;
    }

    @Transient
    public int getDay() {
        if (this.dateFields == null) {
            this.initDateFields();
        }
        return this.dateFields.day;
    }

    @Transient
    public int getDayOfWeek() {
        return (int)((this.getLocalTimestamp() / 86400000L + 1L) % 7L) + 1;
    }

    @Transient
    public int getDaysOfMonth() {
        if (this.dateFields == null) {
            this.initDateFields();
        }
        return UtcTimestamp.getDaysOfMonth(this.dateFields.year, this.dateFields.month);
    }

    @Transient
    public boolean isLeapYear() {
        if (this.dateFields == null) {
            this.initDateFields();
        }
        return UtcTimestamp.isLeapYear(this.dateFields.year);
    }

    @Transient
    public int getHour() {
        return (int)(this.getLocalTimestamp() / 3600000L % 24L);
    }

    @Transient
    public int getMinute() {
        return (int)(this.getLocalTimestamp() / 60000L % 60L);
    }

    @Transient
    public int getSecond() {
        return (int)(this.getLocalTimestamp() / 1000L % 60L);
    }

    @Transient
    public int getMilliSecond() {
        return (int)(this.getLocalTimestamp() % 1000L);
    }

    public void addMilliSeconds(long ms) {
        this.utcMillis = this.utcMillis + ms;
        this.dateFields = null;
    }

    public void addSeconds(long s) {
        this.addMilliSeconds(s * 1000L);
    }

    public void addMinutes(long m) {
        this.addMilliSeconds(m * 60000L);
    }

    public void addHours(long h) {
        this.addMilliSeconds(h * 3600000L);
    }

    public void addDays(long d) {
        this.addMilliSeconds(d * 86400000L);
    }

    public void addMonths(int m) {
        if (this.dateFields == null) {
            this.initDateFields();
        }
        int mmm = this.dateFields.year * 12 + (this.dateFields.month - 1) + m;
        int mm = mmm % 12 + 1;
        int yy = mmm / 12;
        int dd = this.dateFields.day;
        int dom = UtcTimestamp.getDaysOfMonth(yy, mm);
        if (dd == UtcTimestamp.getDaysOfMonth(this.dateFields.year, this.dateFields.month) || dd > dom) {
            dd = dom;
        }
        long ts = UtcTimestamp.makeUtcMillis(yy, mm, dd);
        ts += this.getLocalTimestamp() % 86400000L;
        if (this.tzOffset != null) {
            ts -= (long)this.tzOffset.intValue() * 60000L;
        }
        this.utcMillis = ts;
        this.dateFields = null;
    }

    public void addYears(int y) {
        if (this.dateFields == null) {
            this.initDateFields();
        }
        int dd = this.dateFields.day;
        if (this.dateFields.month == 2 && dd == UtcTimestamp.getDaysOfMonth(this.dateFields.year, this.dateFields.month)) {
            dd = UtcTimestamp.getDaysOfMonth(this.dateFields.year + y, this.dateFields.month);
        }
        long ts = UtcTimestamp.makeUtcMillis(this.dateFields.year + y, this.dateFields.month, dd);
        ts += this.getLocalTimestamp() % 86400000L;
        if (this.tzOffset != null) {
            ts -= (long)this.tzOffset.intValue() * 60000L;
        }
        this.utcMillis = ts;
        this.dateFields = null;
    }

    public void add(int field, int amount) {
        switch (field) {
            case 1: {
                this.addYears(amount);
                break;
            }
            case 2: {
                this.addMonths(amount);
                break;
            }
            case 5: 
            case 6: {
                this.addDays(amount);
                break;
            }
            case 10: 
            case 11: {
                this.addHours(amount);
                break;
            }
            case 12: {
                this.addMinutes(amount);
                break;
            }
            case 13: {
                this.addSeconds(amount);
                break;
            }
            case 14: {
                this.addMilliSeconds(amount);
            }
        }
    }

    public UtcTimestamp cloneAdd(int field, int amount) {
        UtcTimestamp test = null;
        test = (UtcTimestamp)this.clone();
        test.add(field, amount);
        return test;
    }

    public UtcTimestamp cloneAddYears(int amount) {
        return this.cloneAdd(1, amount);
    }

    public UtcTimestamp cloneAddMonths(int amount) {
        return this.cloneAdd(2, amount);
    }

    public UtcTimestamp cloneAddDays(int amount) {
        return this.cloneAdd(5, amount);
    }

    public UtcTimestamp cloneAddHours(int amount) {
        return this.cloneAdd(11, amount);
    }

    public UtcTimestamp cloneAddMinutes(int amount) {
        return this.cloneAdd(12, amount);
    }

    public UtcTimestamp cloneAddSeconds(int amount) {
        return this.cloneAdd(13, amount);
    }

    public UtcTimestamp cloneAddMillis(int amount) {
        return this.cloneAdd(14, amount);
    }

    public void add(TimeZone timeZone, int field, int amount) {
        if (timeZone != null) {
            int old_off = timeZone.getOffset(this.utcMillis);
            this.add(field, amount);
            int new_off = timeZone.getOffset(this.utcMillis);
            if (old_off != new_off) {
                this.tzOffset = this.tzOffset + (new_off - old_off) / 60000;
                this.utcMillis = this.utcMillis - (long)(new_off - old_off);
            }
        } else {
            this.add(field, amount);
        }
    }

    public UtcTimestamp cloneToFirstDayOfWeek(int firstDayOfWeek, TimeZone timeZone) {
        UtcTimestamp ret = (UtcTimestamp)this.clone();
        ret.moveToFirstDayOfWeek(firstDayOfWeek, timeZone);
        return ret;
    }

    public void moveToFirstDayOfWeek(int firstDayOfWeek, TimeZone timeZone) {
        int w = this.getDayOfWeek();
        this.add(timeZone, 5, -(7 + w - firstDayOfWeek) % 7);
    }

    public static int daysBetween(UtcTimestamp t1, UtcTimestamp t2) {
        return (int)(t2.getLocalTimestamp() / 86400000L - t1.getLocalTimestamp() / 86400000L);
    }

    public static int weeksBetween(UtcTimestamp t1, UtcTimestamp t2, int firstDayOfWeek) {
        int days = UtcTimestamp.daysBetween(t1, t2);
        int w1 = t1.getDayOfWeek();
        int w2 = t2.getDayOfWeek();
        days += (7 + w1 - firstDayOfWeek) % 7;
        assert ((days -= (7 + w2 - firstDayOfWeek) % 7) % 7 == 0);
        return days / 7;
    }

    public static int monthsBetween(UtcTimestamp t1, UtcTimestamp t2) {
        return t2.getMonth() - t1.getMonth() + 12 * (t2.getYear() - t1.getYear());
    }

    public String toString(int format) {
        if (this.utcMillis == null) {
            return null;
        }
        if (this.dateFields == null) {
            this.initDateFields();
        }
        if (format == ISO8601Format.DATE_FORMAT) {
            return String.format("%04d-%02d-%02d", this.dateFields.year, this.dateFields.month, this.dateFields.day);
        }
        if (format == ISO8601Format.DATETIME_FORMAT) {
            long ts = this.getLocalTimestamp();
            if (this.tzOffset != null) {
                if (this.tzOffset == 0) {
                    return String.format("%04d-%02d-%02dT%02d:%02d:%02dZ", this.dateFields.year, this.dateFields.month, this.dateFields.day, (int)(ts / 3600000L % 24L), (int)(ts / 60000L % 60L), (int)(ts / 1000L % 60L));
                }
                if (this.tzOffset > 0) {
                    return String.format("%04d-%02d-%02dT%02d:%02d:%02d+%02d:%02d", this.dateFields.year, this.dateFields.month, this.dateFields.day, (int)(ts / 3600000L % 24L), (int)(ts / 60000L % 60L), (int)(ts / 1000L % 60L), this.tzOffset / 60, this.tzOffset % 60);
                }
                return String.format("%04d-%02d-%02dT%02d:%02d:%02d-%02d:%02d", this.dateFields.year, this.dateFields.month, this.dateFields.day, (int)(ts / 3600000L % 24L), (int)(ts / 60000L % 60L), (int)(ts / 1000L % 60L), -this.tzOffset.intValue() / 60, -this.tzOffset.intValue() % 60);
            }
            return String.format("%04d-%02d-%02dT%02d:%02d:%02d", this.dateFields.year, this.dateFields.month, this.dateFields.day, (int)(ts / 3600000L % 24L), (int)(ts / 60000L % 60L), (int)(ts / 1000L % 60L));
        }
        if (format == ISO8601Format.DATETIME_FORMAT_NO_TZ) {
            long ts = this.getLocalTimestamp();
            return String.format("%04d-%02d-%02dT%02d:%02d:%02d", this.dateFields.year, this.dateFields.month, this.dateFields.day, (int)(ts / 3600000L % 24L), (int)(ts / 60000L % 60L), (int)(ts / 1000L % 60L));
        }
        if (format == ISO8601Format.MILLISECOND_FORMAT_NO_TZ) {
            long ts = this.getLocalTimestamp();
            return String.format("%04d-%02d-%02dT%02d:%02d:%02d.%03d", this.dateFields.year, this.dateFields.month, this.dateFields.day, (int)(ts / 3600000L % 24L), (int)(ts / 60000L % 60L), (int)(ts / 1000L % 60L), (int)(ts % 1000L));
        }
        long ts = this.getLocalTimestamp();
        if (this.tzOffset != null) {
            if (this.tzOffset == 0) {
                return String.format("%04d-%02d-%02dT%02d:%02d:%02d.%03dZ", this.dateFields.year, this.dateFields.month, this.dateFields.day, (int)(ts / 3600000L % 24L), (int)(ts / 60000L % 60L), (int)(ts / 1000L % 60L), (int)(ts % 1000L));
            }
            if (this.tzOffset > 0) {
                return String.format("%04d-%02d-%02dT%02d:%02d:%02d.%03d+%02d:%02d", this.dateFields.year, this.dateFields.month, this.dateFields.day, (int)(ts / 3600000L % 24L), (int)(ts / 60000L % 60L), (int)(ts / 1000L % 60L), (int)(ts % 1000L), this.tzOffset / 60, this.tzOffset % 60);
            }
            return String.format("%04d-%02d-%02dT%02d:%02d:%02d.%03d-%02d:%02d", this.dateFields.year, this.dateFields.month, this.dateFields.day, (int)(ts / 3600000L % 24L), (int)(ts / 60000L % 60L), (int)(ts / 1000L % 60L), (int)(ts % 1000L), -this.tzOffset.intValue() / 60, -this.tzOffset.intValue() % 60);
        }
        return String.format("%04d-%02d-%02dT%02d:%02d:%02d.%03d", this.dateFields.year, this.dateFields.month, this.dateFields.day, (int)(ts / 3600000L % 24L), (int)(ts / 60000L % 60L), (int)(ts / 1000L % 60L), (int)(ts % 1000L));
    }

    @Transient
    public void setString(String s) throws ParseException {
        this.setString(s, null);
    }

    @Transient
    public void setString(String s, TimeZone timeZone) throws ParseException {
        int pos = 0;
        try {
            int y = Integer.valueOf(s.substring(pos, pos + 4));
            if (s.charAt(pos += 4) != '-') {
                throw new ParseException(s, pos);
            }
            int m = Integer.valueOf(s.substring(++pos, pos + 2));
            if (s.charAt(pos += 2) != '-') {
                throw new ParseException(s, pos);
            }
            int d = Integer.valueOf(s.substring(++pos, pos + 2));
            if ((pos += 2) < s.length()) {
                if (s.charAt(pos) != 'T') {
                    throw new ParseException(s, pos);
                }
                int hh = Integer.valueOf(s.substring(++pos, pos + 2));
                if (s.charAt(pos += 2) != ':') {
                    throw new ParseException(s, pos);
                }
                int mm = Integer.valueOf(s.substring(++pos, pos + 2));
                if (s.charAt(pos += 2) != ':') {
                    throw new ParseException(s, pos);
                }
                int ss = Integer.valueOf(s.substring(++pos, pos + 2));
                long ms = (long)hh * 3600000L + (long)mm * 60000L + (long)ss * 1000L;
                if ((pos += 2) < s.length() && s.charAt(pos) == '.') {
                    ++pos;
                    int l = 0;
                    while (pos + l < s.length() && Character.isDigit(s.charAt(pos + l))) {
                        ++l;
                    }
                    int sss = Integer.valueOf(s.substring(pos, pos + (l > 3 ? 3 : l)));
                    switch (l) {
                        case 1: {
                            sss *= 100;
                            break;
                        }
                        case 2: {
                            sss *= 10;
                        }
                    }
                    ms += (long)sss;
                    pos += l;
                }
                Integer tz_off = null;
                if (pos < s.length()) {
                    if (s.charAt(pos) == 'Z') {
                        ++pos;
                        tz_off = 0;
                    } else if (s.charAt(pos) == '+') {
                        tz_hh = Integer.valueOf(s.substring(++pos, pos + 2));
                        if (s.charAt(pos += 2) != ':') {
                            throw new ParseException(s, pos);
                        }
                        int tz_mm = Integer.valueOf(s.substring(++pos, pos + 2));
                        pos += 2;
                        tz_off = tz_hh * 60 + tz_mm;
                    } else if (s.charAt(pos) == '-') {
                        tz_hh = Integer.valueOf(s.substring(++pos, pos + 2));
                        if (s.charAt(pos += 2) != ':') {
                            throw new ParseException(s, pos);
                        }
                        int tz_mm = Integer.valueOf(s.substring(++pos, pos + 2));
                        pos += 2;
                        tz_off = tz_hh * -60 - tz_mm;
                    } else {
                        throw new ParseException(s, pos);
                    }
                    if (pos < s.length()) {
                        throw new ParseException(s, pos);
                    }
                }
                if (tz_off != null || timeZone == null) {
                    this.setTzOffset(tz_off);
                    this.setDate(y, m, d);
                    this.addMilliSeconds(ms);
                } else {
                    this.setDateTime(y, m, d, (int)ms, timeZone);
                }
            } else if (timeZone == null) {
                this.setTzOffset(null);
                this.setDate(y, m, d);
            } else {
                this.setDateTime(y, m, d, 0, timeZone);
            }
        }
        catch (NumberFormatException e) {
            throw new ParseException(s, pos);
        }
    }

    public String toString() {
        return this.toString(ISO8601Format.MILLISECOND_FORMAT);
    }

    @Override
    public int compareTo(UtcTimestamp o) {
        if (o == null) {
            return 1;
        }
        if (this.utcMillis == null) {
            if (o.utcMillis == null) {
                return 0;
            }
            return -1;
        }
        if (o.utcMillis == null) {
            return 1;
        }
        return this.utcMillis < o.utcMillis ? -1 : (this.utcMillis > o.utcMillis ? 1 : 0);
    }

    public boolean before(UtcTimestamp other) {
        if (other != null) {
            return this.getUtcMillis() < other.getUtcMillis();
        }
        return false;
    }

    public boolean after(UtcTimestamp other) {
        if (other != null) {
            return this.getUtcMillis() > other.getUtcMillis();
        }
        return true;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof UtcTimestamp)) {
            return false;
        }
        UtcTimestamp ts = (UtcTimestamp)o;
        if (this.getUtcMillis() == null) {
            return ts.getUtcMillis() == null;
        }
        return this.getUtcMillis().equals(ts.getUtcMillis());
    }

    protected Object clone() {
        return new UtcTimestamp(this);
    }

    public int hashCode() {
        if (this.getUtcMillis() == null) {
            return -1;
        }
        return (int)(419430343L * this.getUtcMillis());
    }

    private static class DateFields {
        public final int year;
        public final int month;
        public final int day;

        DateFields(int year, int month, int day) {
            this.year = year;
            this.month = month;
            this.day = day;
        }
    }
}

