package org.clazzes.fancymail.server.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

import org.clazzes.fancymail.server.api.FancyMailServerSMSService;
import org.clazzes.fancymail.server.api.SMSDTO;
import org.clazzes.fancymail.server.api.SMSDestinationDTO;
import org.clazzes.fancymail.server.api.SMSReportDTO;
import org.clazzes.fancymail.server.api.SMSSenderDTO;
import org.clazzes.fancymail.server.entities.SMS;
import org.clazzes.fancymail.server.entities.SMSRecipient;
import org.clazzes.fancymail.server.entities.SMSSender;
import org.clazzes.fancymail.server.service.SMSService;

public class FancyMailServerSMSServiceImpl implements FancyMailServerSMSService {
    
    private static SMSSenderDTO buildSender(SMSSender sender) {
        SMSSenderDTO ret = new SMSSenderDTO();
        ret.setPersonalName(sender.getPersonalName());
        ret.setSourceNumber(sender.getSourceNumber());
        return ret;
    }
    
    private static List<SMSReportDTO> buildReportList(List<SMS> sms) {

        List<SMSReportDTO> ret = new ArrayList<SMSReportDTO>();
        
        for (SMS s:sms) {
            ret.add(buildReport(s));
        }
        
        return ret;
    }
    
    private static SMSDestinationDTO buildAddress(SMSRecipient r) {
        
        SMSDestinationDTO ret = new SMSDestinationDTO();
        ret.setDestNumber(r.getDestinationNumber());
        ret.setPersonalName(r.getPersonalName());
        return ret;
    }
    
    private static SMSReportDTO buildReport(SMS sms) {
        
        SMSReportDTO ret = new SMSReportDTO();
        ret.setSender(sms.getSender().getSourceNumber());
        ret.setText(sms.getText());
        ret.setCreated(new Date(sms.getCreated().getTime()));
        if (sms.getSentAt() != null) {
            ret.setSentAt(new Date(sms.getSentAt().getTime()));            
        }

        ret.setErrorCount(sms.getErrorCount());
        ret.setLastErrorText(sms.getLastErrorText());
        ret.setStatus(sms.getTransmissionReport());
        
        List<SMSDestinationDTO> destinations = new ArrayList<SMSDestinationDTO>();
        
        Collection<SMSRecipient> rec = sms.getRecipients();
        
        for (SMSRecipient r : rec) {
            destinations.add(buildAddress(r));
        }
        ret.setDestinations(destinations);
            
        return ret;
    }    
    
    private SMSService smsService;
    public void setSmsService(SMSService smsService) {
        this.smsService = smsService;
    }

    public SMSSenderDTO getSenderDto(String sourceNumber) {
        SMSSender sender = this.smsService.getSenderBySourceNumber(sourceNumber);
        
        if (sender == null) return null;
        
        return buildSender(sender);
    }

    public List<SMSSenderDTO> getAllSenders() {
        List<SMSSender> senders = this.smsService.getAllSMSSenders();
        
        List<SMSSenderDTO> ret = new ArrayList<SMSSenderDTO>(senders.size());
        
        for (SMSSender sender : senders) {
            ret.add(buildSender(sender));
        }
         
        return ret;        
    }

    public void insertSender(SMSSenderDTO sender) {
        this.smsService.insertSender(sender);
    }

    public void updateSender(SMSSenderDTO sender) {
        this.smsService.updateSender(sender);
    }

    public void updateSenders(Collection<SMSSenderDTO> senders) {
        this.smsService.updateSenders(senders);
    }

    public Date queueSMS(SMSDTO smsDto) {
        SMS sms = this.smsService.insertSMS(smsDto);
        // mail.getCreated() may be a proxy of the JPA provider, which may not be serialized without
        // major headaches, so clone it here.
        return new Date(sms.getCreated().getTime());
    }

    public List<SMSReportDTO> getAllSMS(Date from, Date to, String sourceNumber, String destNumber) {
        if (sourceNumber == null) {
            if (destNumber == null) {
                return buildReportList(this.smsService.getAllSMSInRange(from,to));
            } else {
                return buildReportList(this.smsService.getAllSMSInRangeForRecipient(destNumber,from,to));
            }
        } else {
            if (destNumber == null) {
                return buildReportList(this.smsService.getAllSMSInRangeForSender(sourceNumber,from,to));
            } else {
                return buildReportList(this.smsService.getAllSMSInRangeForSenderRecipient(sourceNumber, destNumber,from,to));
            }
        }
    }
}
