package org.clazzes.fancymail.server.service.impl;

import org.clazzes.fancymail.sms.ISMS;
import org.clazzes.fancymail.sms.ISMSChannel;
import org.clazzes.fancymail.sms.SMSException;
import org.clazzes.svc.api.ServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegatingSMSChannel implements ISMSChannel {

    private static final Logger log = LoggerFactory.getLogger(DelegatingSMSChannel.class);

    private ServiceRegistry smsChannelMap;
    private ISMSChannel smppDelegate;
    private String svcKey;

    public void setSmsBackend(String smsBackend) {

        if (smsBackend.startsWith("svc:")) {
            this.svcKey =  smsBackend.substring(4);
            log.info ("Will use service with key [{}] for SMS delivery.",this.svcKey);
        }
        else if ("static:smpp".equals(smsBackend)) {

            log.info ("Will use built-in SMPP client for SMS delivery.");
            this.svcKey = null;
        }
        else {
            throw new IllegalArgumentException("SMS backend must be [svc:*] or [static:smpp]");
        }
    }

    public void setSmsChannelMap(ServiceRegistry smsChannelMap) {
        this.smsChannelMap = smsChannelMap;
    }

    public void setSmppDelegate(ISMSChannel smppDelegate) {
        this.smppDelegate = smppDelegate;
    }

    protected ISMSChannel getDelegate() {
        if (this.svcKey == null) {
            return this.smppDelegate;
        } else {
            return this.smsChannelMap.getService(this.svcKey, ISMSChannel.class).get();
        }
    }

    @Override
    public boolean sendSMSNow(ISMS sms) throws SMSException, InterruptedException {

        return this.getDelegate().sendSMSNow(sms);
    }

    @Override
    public boolean supportsSenderFaking() {

        return this.getDelegate().supportsSenderFaking();
    }

}