package org.clazzes.fancymail.server.service;

import java.util.Collection;
import java.util.Date;
import java.util.List;

import org.clazzes.fancymail.server.api.SMSDTO;
import org.clazzes.fancymail.server.api.SMSSenderDTO;
import org.clazzes.fancymail.server.entities.SMS;
import org.clazzes.fancymail.server.entities.SMSSender;
import org.clazzes.fancymail.sms.ISMSFactory;
import org.clazzes.fancymail.sms.ISMSReportConsumer;

public interface SMSService extends ISMSFactory, ISMSReportConsumer {
    
    public SMSSender getSenderBySourceNumber(String sourceNumber);
    
    public List<SMSSender> getAllSMSSenders();
    
    public SMSSender insertSender(SMSSenderDTO sender);

    public SMSSender updateSender(SMSSenderDTO sender);
    
    public void updateSenders(Collection<SMSSenderDTO> senders);
    
    public SMS insertSMS(SMSDTO sms);
    
    public List<SMS> getAllSMSInRange(Date from, Date to);

    public List<SMS> getAllSMSInRangeForSender(String sender, Date from, Date to);

    public List<SMS> getAllSMSInRangeForRecipient(String sender, Date from, Date to);
    
    public List<SMS> getAllSMSInRangeForSenderRecipient(String senderAddr, String recipientAddr, Date from, Date to);

    public int deleteOutdatedSMSs(Date watermark);
}
