/***********************************************************
 * $Id$
 * 
 * FancyMail standalone OSGi server of the clazzes.org project
 * http://www.clazzes.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.fancymail.server.service;

import java.util.Collection;
import java.util.Date;
import java.util.List;

import javax.activation.DataSource;

import org.clazzes.fancymail.sending.IEMailFactory;
import org.clazzes.fancymail.sending.IEMailReportConsumer;
import org.clazzes.fancymail.server.api.EMailDTO;
import org.clazzes.fancymail.server.api.EMailSenderDTO;
import org.clazzes.fancymail.server.entities.EMail;
import org.clazzes.fancymail.server.entities.EMailSender;

/**
 * All internally and externally used functionality.
 * This service interface will be intercepted with JDBC interceptors. 
 */
public interface EMailService extends IEMailFactory, IEMailReportConsumer{

    EMail insertEMail(EMailDTO email);
    
    EMail insertEMailWithAttachments(EMailDTO email, List<DataSource> attachments);

    int deleteOutdatedEMails(Date watermark);
    
    public List<EMail> getAllEMailsInRange(Date from, Date to);

    public List<EMail> getAllEMailsInRangeForSender(String sender, Date from, Date to);

    public List<EMail> getAllEMailsInRangeForRecipient(String sender, Date from, Date to);

    EMailSender getSenderByAddr(String emailAddr);

    List<EMailSender> getAllEMailSenders();
 
    public EMailSender insertSender(EMailSenderDTO sender);

    EMailSender updateSender(EMailSenderDTO sender);

    void updateSenders(Collection<EMailSenderDTO> senders);

    List<EMail> getAllEMailsInRangeForSenderRecipient(String senderAddr,
            String recipientAddr, Date from, Date to);
}
