package org.clazzes.fancymail.server.entities;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.clazzes.fancymail.sms.ISMS;

public class SMS implements ISMS {

    public static final int SMS_STATUS_UNKNOWN = 0;
    public static final int SMS_STATUS_TOSEND = 1;
    public static final int SMS_STATUS_SENT = 2;
    public static final int SMS_STATUS_SENDERROR = 3;
    // maximal number of retries are exceeded.
    public static final int SMS_STATUS_FAILED = 4;
    public static final int SMS_STATUS_SENDING = 99;

    private Long id;
    private String text;
    private int status;
    private int errorCount;
    private String lastErrorText;
    private Date sentAt;
    private SMSSender sender;
    private Date created;
    private Date sending;
    private String lastErrorException;

    private List<SMSRecipient> recipients;

    public SMS() {
        this.status = SMS_STATUS_UNKNOWN;
        this.lastErrorText = "";
    }

    public String getText() {
        return this.text;
    }

    public String getSenderNumber() {
        return this.sender.getSourceNumber();
    }

    public SMSSender getSender() {
        return this.sender;
    }

    public List<SMSRecipient> getRecipients() {
        return this.recipients;
    }

    public List<String> getRecipientNumbers() {
        List<String> recipientNumbers = new ArrayList<String>();
        for (SMSRecipient recipient : recipients) {
            recipientNumbers.add(recipient.getDestinationNumber());
        }

        return recipientNumbers;
    }


    public void setSent(String successDesc) {
        this.setStatus(SMS_STATUS_SENT);
        this.setLastErrorText(successDesc);
        this.setSentAt(new Date());
        this.setSending(null);
        this.setLastErrorException(null);
    }

    public void setUnsent(String errorDesc) {
        this.setErrorCount(this.getErrorCount() + 1);
        this.setStatus(SMS_STATUS_SENDERROR);
        this.setLastErrorText(errorDesc);
        this.setSending(null);
        this.setLastErrorException(null);
    }

    @Override
    public void setUnsent(String errorDesc, Exception e) {
        this.setErrorCount(this.getErrorCount() + 1);
        this.setStatus(SMS_STATUS_SENDERROR);
        this.setLastErrorText(errorDesc);
        this.setSending(null);
        this.setLastErrorException(e.getClass().getName());
    }

    public void setSendingState(Date now) {

        this.setStatus(SMS_STATUS_SENDING);
        this.setLastErrorText("Sending...");
        this.setSending(now);
        this.setLastErrorException(null);
    }

    public boolean isSent() {
        return this.getStatus() == SMS_STATUS_SENT;
    }

    public String getTransmissionReport() {
        switch (this.getStatus())
        {
        case SMS_STATUS_SENT:
            return "Sent OK";
        case SMS_STATUS_SENDERROR:
            return "NOT SENT! Error: " + this.getLastErrorText();
        case SMS_STATUS_FAILED:
            return "NOT SENT! Maximal number of retries exceeded.";
        default:
            return "Not yet transmitted.";
        }
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return this.id;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getStatus() {
        return this.status;
    }

    public void setErrorCount(int errorCount) {
        this.errorCount = errorCount;
    }

    public void setLastErrorText(String lastErrorText) {
        this.lastErrorText = lastErrorText;
    }

    public String getLastErrorText() {
        return this.lastErrorText;
    }

    public void setSentAt(Date sentAt) {
        this.sentAt = sentAt;
    }

    public Date getSentAt() {
        return this.sentAt;
    }

    public void setSender(SMSSender sender) {
        this.sender = sender;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public Date getCreated() {
        return this.created;
    }

    public Date getSending() {
        return this.sending;
    }

    public void setSending(Date sending) {
        this.sending = sending;
    }

    public String getLastErrorException() {
        return this.lastErrorException;
    }

    public void setLastErrorException(String lastErrorException) {
        this.lastErrorException = lastErrorException;
    }

    public void setRecipients(List<SMSRecipient> recipients) {
        this.recipients = recipients;
    }

    public void addRecipient(SMSRecipient recipient) {

        if (this.recipients == null) {
            this.recipients = new ArrayList<SMSRecipient>();
        }

        this.recipients.add(recipient);
    }

    @Override
    public String toString() {
        return "SMS [id=" + this.id +
               ", created=" + this.created +
               ", errorCount=" + this.errorCount +
               ", recipients=" + this.recipients + "]";
    }

}
