/***********************************************************
 * $Id$
 * 
 * FancyMail standalone OSGi server of the clazzes.org project
 * http://www.clazzes.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.fancymail.server.entities;

import java.io.Serializable;

/**
 * A sender of an EMail with an optional personal name and an optional reply-to address.
 */
public class EMailSender implements Serializable {

    private static final long serialVersionUID = 8524973506115746428L;

    private Long id;
    private String personalName;
    private String address;
    private String replyTo;
    
    /**
     * @return the id
     */
    public Long getId() {
        return this.id;
    }
    /**
     * @param id the id to set
     */
    public void setId(Long id) {
        this.id = id;
    }
    
    /**
     * @return the optional personal name, which is put as additional information
     *           alongside the e-mail address.
     */
    public String getPersonalName() {
        return this.personalName;
    }
    /**
     * @param personalName the personalName to set
     */
    public void setPersonalName(String personalName) {
        this.personalName = personalName;
    }
    /**
     * @return the RFC822 e-mail address.
     */
    public String getAddress() {
        return this.address;
    }
    /**
     * @param address the RFC822 e-mail address to set
     */
    public void setAddress(String address) {
        this.address = address;
    }
    /**
     * @return the replyTo as RFC822 e-mail address.
     */
    public String getReplyTo() {
        return this.replyTo;
    }
    /**
     * @param replyTo the replyTo as RFC822 e-mail address to set.
     */
    public void setReplyTo(String replyTo) {
        this.replyTo = replyTo;
    }
    
    public String toString() {
        
        if (this.getReplyTo() == null && this.getPersonalName() == null)
            return this.getAddress();
        
        StringBuffer sb = new StringBuffer();
        
        if (this.getPersonalName() != null) {
            sb.append(this.getPersonalName());
            sb.append(" <");
        }
        
        sb.append(this.getAddress());
        
        if (this.getPersonalName() != null) {
            sb.append(">");
        }
        
        if (this.getReplyTo() != null) {
            sb.append("(Reply-to: ");
            sb.append(this.getReplyTo());
            sb.append(")");
        }
      
        return sb.toString(); 
    }
}
