/***********************************************************
 * $Id$
 * 
 * FancyMail standalone OSGi server of the clazzes.org project
 * http://www.clazzes.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.fancymail.server.entities;

import java.io.Serializable;

/**
 * A recipient a EMail, which is either a <code>To:</code>,
 * <code>CC:</code> or <code>BCC:</code> entitlement.
 */
public class EMailRecipient implements Serializable {

    private static final long serialVersionUID = 1441067589941217902L;

    public static final int RECIPIENT_TO = 1;
    public static final int RECIPIENT_CC = 2;
    public static final int RECIPIENT_BCC = 3;
    
    private Long id;
    private Long emailId;
    private int entitlement;
    private String personalName;
    private String address;
    
    /**
     * @return the id
     */
    public Long getId() {
        return this.id;
    }
    /**
     * @param id the id to set
     */
    public void setId(Long id) {
        this.id = id;
    }
        
    /**
     * @return the ID of the mail to which this recipient belongs.
     */
    public Long getEmailId() {
        return emailId;
    }

    /**
     * @param emailId the ID of the mail to which this recipient belongs to set.
     */
    public void setEmailId(Long emailId) {
        this.emailId = emailId;
    }

    /**
     * @return the entitlement
     * 
     * @see EMailRecipient#RECIPIENT_TO
     * @see EMailRecipient#RECIPIENT_CC
     * @see EMailRecipient#RECIPIENT_BCC
     */
    public int getEntitlement() {
        return this.entitlement;
    }
    /**
     * @param entitlement the entitlement to set.
     * 
     * @see EMailRecipient#RECIPIENT_TO
     * @see EMailRecipient#RECIPIENT_CC
     * @see EMailRecipient#RECIPIENT_BCC
     */
    public void setEntitlement(int entitlement) {
        this.entitlement = entitlement;
    }
    /**
     * @return the optional personal name, which is put as additional information
     *           alongside the e-mail address.
     */
    public String getPersonalName() {
        return this.personalName;
    }
    /**
     * @param personalName the personalName to set
     */
    public void setPersonalName(String personalName) {
        this.personalName = personalName;
    }
    /**
     * @return the RFC822 e-mail address.
     */
    public String getAddress() {
        return this.address;
    }
    /**
     * @param address the RFC822 e-mail address to set
     */
    public void setAddress(String address) {
        this.address = address;
    }
    
    public String toString() {
        
        StringBuffer sb = new StringBuffer();
        
        switch(this.getEntitlement()) {
        
        case RECIPIENT_TO: sb.append("To: "); break;
        case RECIPIENT_CC: sb.append("CC: "); break;
        case RECIPIENT_BCC: sb.append("BCC: "); break;
        default: sb.append("UNKNOWN_ENTITLEMENT: ");
        }
        
        if (this.getPersonalName() != null) {
            sb.append(this.getPersonalName());
            sb.append(" <");
        }
        
        sb.append(this.getAddress());
        
        if (this.getPersonalName() != null) {
            sb.append(">");
        }
        
        return sb.toString(); 

    }
    
}
