/***********************************************************
 * $Id$
 * 
 * FancyMail standalone OSGi server of the clazzes.org project
 * http://www.clazzes.org
 *
 * Created: 06.05.2018
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.fancymail.server.entities;

import java.io.Serializable;

import javax.activation.DataSource;
import javax.mail.util.ByteArrayDataSource;

import org.clazzes.fancymail.mail.IEMail;
import org.clazzes.fancymail.mail.IEMailAttachment;

/**
 * An e-mail attachment as persisted to the fancymail-server DB.
 */
public class EMailAttachment implements Serializable, IEMailAttachment {

    private static final long serialVersionUID = -855797028573333874L;

    private Long id;
    private IEMail email;
    private String mimeType;
    private String prettyName;
    private byte[] content;
        
    /**
     * @return The database ID.
     */
    public Long getId() {
        return this.id;
    }

    /**
     * @param id The database ID to set.
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * @return The actual content.
     */
    public byte[] getContent() {
        return this.content;
    }

    /**
     * @param content The content of the attachemnt to set.
     */
    public void setContent(byte[] content) {
        this.content = content;
    }

    /* (non-Javadoc)
     * @see org.clazzes.fancymail.mail.IEMailAttachment#getDataSource()
     */
    @Override
    public DataSource getDataSource() {
        
        ByteArrayDataSource ret = new ByteArrayDataSource(this.content,this.mimeType);
        ret.setName(this.prettyName);
        return ret;
    }

    /* (non-Javadoc)
     * @see org.clazzes.fancymail.mail.IEMailAttachment#getEMail()
     */
    @Override
    public IEMail getEMail() {
        
        return this.email;
    }

    /* (non-Javadoc)
     * @see org.clazzes.fancymail.mail.IEMailAttachment#getMimeType()
     */
    @Override
    public String getMimeType() {
        
        return this.mimeType;
    }

    /* (non-Javadoc)
     * @see org.clazzes.fancymail.mail.IEMailAttachment#getPrettyName()
     */
    @Override
    public String getPrettyName() {
        
        return this.prettyName;
    }

    /* (non-Javadoc)
     * @see org.clazzes.fancymail.mail.IEMailAttachment#setMail(org.clazzes.fancymail.mail.IEMail)
     */
    @Override
    public void setMail(IEMail mail) {
        
        this.email = mail;
    }

    /* (non-Javadoc)
     * @see org.clazzes.fancymail.mail.IEMailAttachment#setMimeType(java.lang.String)
     */
    @Override
    public void setMimeType(String mimeType) {
        
        this.mimeType = mimeType;
    }

    /* (non-Javadoc)
     * @see org.clazzes.fancymail.mail.IEMailAttachment#setPrettyName(java.lang.String)
     */
    @Override
    public void setPrettyName(String prettyName) {
        
        this.prettyName = prettyName;
    }

}
