package org.clazzes.fancymail.server.dao.jdbc;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.clazzes.fancymail.sms.SMSEngine;

public class SMSThreadInterceptor implements MethodInterceptor {
    
    private SMSEngine smsEngine;
    public void setSMSEngine(SMSEngine smsEngine) {
        this.smsEngine = smsEngine;
    }
    
    public Object invoke(MethodInvocation invocation) throws Throwable {
        
        try {
            Object ret = invocation.proceed();
            
            if ("insertSMS".equals(invocation.getMethod().getName())) {
                this.smsEngine.wake();                
            }
            
            return ret;
        } finally {
        }
    }        


}
