package org.clazzes.fancymail.server.dao.jdbc;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.clazzes.fancymail.server.dao.SMSDestinationDAO;
import org.clazzes.fancymail.server.entities.SMS;
import org.clazzes.fancymail.server.entities.SMSRecipient;
import org.clazzes.util.aop.jdbc.JdbcPreparedStatementAction;
import org.clazzes.util.sql.criteria.SQLCondition;
import org.clazzes.util.sql.criteria.SQLValue;
import org.clazzes.util.sql.dao.AbstrIdDAO;
import org.clazzes.util.sql.dao.StatementPreparer;
import org.clazzes.util.sql.helper.JDBCHelper;

public class JdbcSMSDestinationDAO extends AbstrIdDAO<SMSRecipient> implements
        SMSDestinationDAO {
    
    public JdbcSMSDestinationDAO() {
        super(SMSRecipient.class,"id","SMS_RECIPIENT",new String[]{
            "ID",
            "SMS_ID",
            "DEST_NUMBER",
            "PERSONAL_NAME"
        });
    }    
    
    public void fetchAllForSMS(final Collection<SMS> sms, final SQLCondition condition, final StatementPreparer preparer) {
        final Map<Long,SMS> smsById = new HashMap<Long,SMS>(sms.size());
        
        for (SMS s : sms) {
            smsById.put(s.getId(), s);
        }
        
        String sql = this.getGenerator().innerJoin(
                this.getTableName(),
                "SMS",
                SQLCondition.eq(
                        SQLValue.tableColumn(this.getTableName(),"SMS_ID"),
                        SQLValue.tableColumn("SMS","ID")),
                condition,
                SQLValue.columnList(this.getTableName(),this.getColumnNames()));
        
        this.performWithPreparedStatement(sql,new JdbcPreparedStatementAction<Void>() {

            @Override
            public Void perform(PreparedStatement statement) throws Exception {
               
                preparer.fillInsertValues(statement);
                
                ResultSet rs = statement.executeQuery();
                
                while (rs.next()) {
                    
                    SMSRecipient destination = JdbcSMSDestinationDAO.this.fillDtoFromResultSet(rs);
                    
                    SMS s = smsById.get(destination.getSmsId());
                    
                    if (s != null) {
                        s.addRecipient(destination);
                    }
                }
                
                return null;
            }
        });
    }    

    @Override
    protected SMSRecipient fillDtoFromResultSet(ResultSet rs) throws SQLException {
        SMSRecipient ret = new SMSRecipient();
        
        ret.setId(JDBCHelper.getLong(rs,1));
        ret.setSmsId(JDBCHelper.getLong(rs,2));
        ret.setDestinationNumber(rs.getString(3));
        ret.setPersonalName(rs.getString(4));
         
        return ret;
    }

    @Override
    protected void fillPreparedStatementFromDto(PreparedStatement statement,
            SMSRecipient dto) throws SQLException {
        
        JDBCHelper.setLong(statement,1,dto.getId());
        JDBCHelper.setLong(statement,2,dto.getSmsId());
        statement.setString(3,dto.getDestinationNumber());
        statement.setString(4,dto.getPersonalName());
    }
    
    @Override
    public int[] deleteAllForSMSs(final List<Long> smsIds) {
        
        String sql = this.getGenerator().delete(this.getTableName(),
                SQLCondition.eq(SQLValue.tableColumn(this.getTableName(),"SMS_ID"),
                        SQLValue.INSERT_VALUE));
        
        return this.performWithPreparedStatement(sql,new JdbcPreparedStatementAction<int[]>() {

            @Override
            public int[] perform(PreparedStatement statement) throws Exception {
               
                for (Long emailId : smsIds) {
                
                    JDBCHelper.setLong(statement,1,emailId);
                    statement.addBatch();
                }
                
                return statement.executeBatch();
            }
        });
    }

}
